% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MazamaSpatialUtils.R
\name{dissolve}
\alias{dissolve}
\title{Aggregate shapes in a SpatialPolygonsDataFrame}
\usage{
dissolve(SPDF, field = NULL, sum_fields = NULL, copy_fields = NULL,
  ...)
}
\arguments{
\item{SPDF}{object of class SpatialPolygonsDataFrame}

\item{field}{proportion of points to retain (0-1; default 0.05)}

\item{sum_fields}{fields to sum}

\item{copy_fields}{fields to copy. The first instance of each field will be copied to the aggregated feature}

\item{...}{arguments passed to \code{rmapshaper::ms_dissolve()}}
}
\value{
A spatial polygons dataframe with aggregated shapes.
}
\description{
Aggregate shapes in a spatial polygons dataframe. This is a convenience
wrapper for \code{rmapshaper::ms_dissolve()}
}
\examples{
regions <- dissolve(SimpleCountries, field = "UN_region", sum_fields = "area")
plot(regions)
regions@data
}
