% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getNearestLocation.R
\name{table_getNearestLocation}
\alias{table_getNearestLocation}
\title{Return known locations}
\usage{
table_getNearestLocation(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Vector of longitudes in decimal degrees E.}

\item{latitude}{Vector of latitudes in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}
}
\value{
Tibble of known locations.
}
\description{
Returns a tibble of known locations from \code{locationTbl}, one
for each incoming location. If no known location is found for a particular
incoming location, that record in the tibble will contain all \code{NA}.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Too small a distanceThreshold will not find a match
table_getNearestLocation(locationTbl, lon, lat, distanceThreshold = 50) \%>\% str()

# Expanding the distanceThreshold will find one
table_getNearestLocation(locationTbl, lon, lat, distanceThreshold = 5000) \%>\% str()
}
