% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addLocation.R
\name{table_addLocation}
\alias{table_addLocation}
\title{Add new known location records to a table}
\usage{
table_addLocation(locationTbl = NULL, longitude = NULL,
  latitude = NULL, radius = NULL, stateDataset = "NaturalEarthAdm1",
  verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{longitude}{Vector of longitudes in decimal degrees E, Default: NULL}

\item{latitude}{Vector of latitudes in decimal degrees N, Default: NULL}

\item{radius}{Radius in meters, Default: NULL}

\item{stateDataset}{Name of spatial dataset to use for determining state
codes, Default: 'NaturalEarthAdm1'}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Incoming \code{longitude} and \code{latitude} values are compared 
against the incoming \code{locationTbl} to see if the are already within
\code{radius} meters of an existing entry. A new record is created for
each location that is not already found in \code{locationTbl}.
}
\note{
This funciton is a vecorized version of \code{table_addSingleLocation()}.
}
\examples{
\donttest{
# Set up standard directories and spatial data
spatialDataDir <- tempdir() # typically "~/Data/Spatial"
mazama_initialize(spatialDataDir)

locationTbl <- get(data("wa_monitors_500"))

# Coulee City, WA
lon <- -119.290904
lat <- 47.611942

locationTbl <- 
  locationTbl \%>\%
  table_addLocation(lon, lat, radius = 500)
}
}
\seealso{
\link{table_addSingleLocation}

\link{table_removeRecord}

\link{table_updateSingleRecord}
}
