% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Meta.Sampling.R, R/iKernelABC.R
\name{meta_sampling}
\alias{meta_sampling}
\alias{MaxWiK.predictor}
\alias{get.MaxWiK}
\title{Function to get Approximate Bayesian Computation based on Maxima Weighted Isolation Kernel mapping}
\usage{
meta_sampling(
  psi = 4,
  t = 35,
  param,
  stat.sim,
  stat.obs,
  talkative = FALSE,
  check_pos_def = FALSE,
  n_bullets = 16,
  n_best = 10,
  halfwidth = 0.5,
  epsilon = 0.001,
  rate = 0.1,
  max_iteration = 15,
  save_web = TRUE,
  use.iKernelABC = NULL
)

MaxWiK.predictor(
  psi = 4,
  t = 35,
  param,
  stat.sim,
  new.param,
  talkative = FALSE,
  check_pos_def = FALSE,
  n_bullets = 16,
  n_best = 10,
  halfwidth = 0.5,
  epsilon = 0.001,
  rate = 0.1,
  max_iteration = 15,
  save_web = TRUE,
  use.iKernelABC = NULL
)

get.MaxWiK(
  psi = 40,
  t = 350,
  param,
  stat.sim,
  stat.obs,
  talkative = FALSE,
  check_pos_def = TRUE,
  Matrix_Voronoi = NULL
)
}
\arguments{
\item{psi}{Integer number. Size of each Voronoi diagram or number of areas/points in the Voronoi diagrams}

\item{t}{Integer number of trees in the Isolation Forest}

\item{param}{or \code{par.sim} - data frame of parameters of the model}

\item{stat.sim}{Summary statistics of the simulations (model output)}

\item{stat.obs}{Summary statistics of the observation point}

\item{talkative}{Logical parameter to print or do not print messages}

\item{check_pos_def}{Logical parameter to check the Gram matrix is positive definite or do not check}

\item{n_bullets}{Number of generating points between two}

\item{n_best}{Number of the best points to construct the next web net}

\item{halfwidth}{Parameter for the algorithm of deleting of generated points}

\item{epsilon}{Criterion to stop meta-sampling}

\item{rate}{Rate to renew points in the web net of generated points}

\item{max_iteration}{Maximum of iterations during meta-sampling}

\item{save_web}{Logical to save all the generated points (web net)}

\item{use.iKernelABC}{The iKernelABC object to use for meta-sampling. By default it is NULL and is generated.}

\item{new.param}{New parameter for the predictor input}

\item{Matrix_Voronoi}{is a predefined matrix of information about Voronoi trees
(rows - trees, columns - Voronoi points/areas IDs). By default it is NULL and is generated randomly.}
}
\value{
The function \code{meta_sampling()} returns the list of the next objects:
\itemize{
\item input.parameters that is the list of all the input parameters for Isolation Kernel ABC method;
\item iteration that is iteration value when algorithm stopped;
\item network that is network points when algorithm stopped;
\item par.best that is data frame of one point that is the best from all the generated tracer points;
\item sim.best that is numeric value of the similarity of the best tracer point;
\item iKernelABC that is result of the function \code{get.MaxWiK()} given on \code{input parameters};
\item spiderweb that is the list of all the networks during the meta-sampling.
}

The function \code{MaxWiK.predictor()} returns the list of the next objects:
\itemize{
\item input.parameters that is the list of all the input parameters for Isolation Kernel ABC method;
\item iteration that is iteration value when algorithm stopped;
\item network that is network points when algorithm stopped;
\item prediction.best that is data frame of one point that is the best from all the generated tracer points;
\item sim.best that is numeric value of the similarity of the best tracer point;
\item iKernelABC that is result of the function \code{get.MaxWiK()} given on \code{input parameters};
\item spiderweb that is the list of all the networks during the meta-sampling.
}

The function \code{get.MaxWiK()} returns the list of :
\itemize{
\item kernel_mean_embedding is a maxima weighted kernel mean embedding (mapping) related to the observation point;
\item parameters_Matrix_Voronoi is a matrix of information about Voronoi trees (rows - trees, columns - Voronoi points/areas IDs) for parameters data set;
\item parameters_Matrix_iKernel is a matrix of of all points of PARAMETERS in a Hilbert space (rows - points, columns - isolation trees);
\item Hilbert_weights is a weights in Hilbert space to get maxima weighted kernel mean embedding for parameters_Matrix_iKernel;
\item Matrix_iKernel is a matrix of all points of simulations in a Hilbert space (rows - points, columns - isolation trees);
\item iFeature_point is a feature embedding mapping for the OBSERVATION point;
\item similarity is a vector of similarities between the simulation points and observation point;
\item Matrix_Voronoi is a matrix of information about Voronoi trees (rows - trees, columns - Voronoi points/areas IDs);
\item t is a number of trees in the Isolation Forest;
\item psi is a number of areas/points in the Voronoi diagrams
}
}
\description{
The function \code{meta_sampling()} iteratively generates tracer based on the simple procedure: \cr
\itemize{
\item making a reflection of the top points from the best point, \cr
\item and then generating the point tracers between them, \cr
\item finally, the algorithm chooses again the top points and the best point (\code{sudoku()} function is used),
\item repeat all the steps until condition to be \code{TRUE}: \cr
\code{abs( min( sim_tracers ) - sim_previous ) < epsilon }
}

The function \code{MaxWiK.predictor()} uses the meta-sampling for a prediction

The function \code{get.MaxWiK()} is used to get Approximate Bayesian Computation
based on Maxima Weighted Isolation Kernel mapping.
On given data frame of parameters, statistics of the simulations and an observation,
using the internal parameters psi and t,
the function \code{get.MaxWiK()} returns the estimation of a parameter corresponding to
Maxima weighted Isolation Kernel ABC method.
}
\section{Functions}{
\itemize{
\item \code{meta_sampling()}: The function to get the best value of parameter corresponding to
Maxima Weighted Isolation Kernel mapping which is related to an observation point

\item \code{MaxWiK.predictor()}: The function to get the prediction of output based on a new parameter and MaxWiK

}}
\examples{
MaxWiK::MaxWiK_templates(dir = tempdir()) # See the template 'MaxWiK.ABC.R' and 
# vignettes for usage.
MaxWiK::MaxWiK_templates(dir = tempdir()) # See the template 'MaxWiK.Predictor.R' 
# and vignettes for usage. 
MaxWiK::MaxWiK_templates(dir = tempdir()) # See the template 'MaxWiK.ABC.R' and 
# vignettes for usage.
}
