% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue.R
\name{pvalue}
\alias{pvalue}
\title{p-value Function}
\usage{
pvalue(S0, S, type = c("geq", "leq", "absolute", "two-tailed"))
}
\arguments{
\item{S0}{An atomic vector. Value of the test statistic
applied to the data.}

\item{S}{A vector. It consists of replications of the test statistic.
\code{S} must have length greater than one.}

\item{type}{A character string. It specifies the type of test
the p-value function produces. The possible values are
\code{geq}, \code{leq}, \code{absolute} and \code{two-tailed}.
 Default is \code{geq}.}
}
\value{
The p-value of the statistic \code{S0} given a vector of replications \code{S}.
}
\description{
Computes the p-value of the statistic by computing its rank
compared to its simulated values.
}
\details{
We allow for four types of p-value: \code{leq}, \code{geq},
\code{absolute} and \code{two-tailed}. For one-tailed test,
\code{leq} returns the proportion of simulated values smaller
than the statistic while \code{geq} returns the proportion of
simulated values greater than the statistic. For two-tailed
test with a symmetric satistic, one can use the
absolute value of the statistic and its simulated values to
retrieve a two-tailed test (i.e. type = \code{absolute}).
If the statistic is not symmetric, one can specify the p-value
type as \code{two-tailed} which is equivalent to twice the minimum
of \code{leq} and \code{geq}.

Ties in the ranking are broken according to a uniform
distribution.
}
\examples{
# Generate sample S0 and simulate statistics
S0 = 0
S = rnorm(99)

# Compute p-value
pvalue(S0, S, type = "geq")
}
\references{
Dufour, J.-M. (2006), Monte Carlo Tests with nuisance parameters:
A general approach to finite sample inference and nonstandard asymptotics in econometrics.
\emph{Journal of Econometrics}, \bold{133(2)}, 443-447.

Dufour, J.-M. and Khalaf L. (2003), Monte Carlo Test Methods in Econometrics.
in Badi H. Baltagi, ed., \emph{A Companion to Theoretical Econometrics}, Blackwell Publishing Ltd, 494-519.
}
