% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignment.R
\name{assignment}
\alias{assignment}
\alias{[<-,dgRMatrix,index,index,replValue-method}
\alias{[<-,dgRMatrix,missing,index,replValue-method}
\alias{[<-,dgRMatrix,index,missing,replValue-method}
\alias{[<-,dgRMatrix,missing,missing,replValue-method}
\alias{[<-,dgRMatrix,index,index,sparseVector-method}
\alias{[<-,dgRMatrix,missing,index,sparseVector-method}
\alias{[<-,dgRMatrix,index,missing,sparseVector-method}
\alias{[<-,dgRMatrix,missing,missing,sparseVector-method}
\alias{[<-,ANY,nsparseVector,nsparseVector,replValue-method}
\alias{[<-,ANY,missing,nsparseVector,replValue-method}
\alias{[<-,ANY,nsparseVector,missing,replValue-method}
\alias{[<-,ANY,lsparseVector,lsparseVector,replValue-method}
\alias{[<-,ANY,missing,lsparseVector,replValue-method}
\alias{[<-,ANY,lsparseVector,missing,replValue-method}
\alias{[<-,ANY,nsparseVector,nsparseVector,ANY-method}
\alias{[<-,ANY,missing,nsparseVector,ANY-method}
\alias{[<-,ANY,nsparseVector,missing,ANY-method}
\alias{[<-,ANY,lsparseVector,lsparseVector,ANY-method}
\alias{[<-,ANY,missing,lsparseVector,ANY-method}
\alias{[<-,ANY,lsparseVector,missing,ANY-method}
\title{Assignment operator for CSR matrices}
\usage{
\S4method{[}{dgRMatrix,index,index,replValue}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,missing,index,replValue}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,index,missing,replValue}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,missing,missing,replValue}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,index,index,sparseVector}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,missing,index,sparseVector}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,index,missing,sparseVector}(x, i, j, ...) <- value

\S4method{[}{dgRMatrix,missing,missing,sparseVector}(x, i, j, ...) <- value

\S4method{[}{ANY,nsparseVector,nsparseVector,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,missing,nsparseVector,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,nsparseVector,missing,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,lsparseVector,lsparseVector,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,missing,lsparseVector,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,lsparseVector,missing,replValue}(x, i, j, ...) <- value

\S4method{[}{ANY,nsparseVector,nsparseVector,ANY}(x, i, j, ...) <- value

\S4method{[}{ANY,missing,nsparseVector,ANY}(x, i, j, ...) <- value

\S4method{[}{ANY,nsparseVector,missing,ANY}(x, i, j, ...) <- value

\S4method{[}{ANY,lsparseVector,lsparseVector,ANY}(x, i, j, ...) <- value

\S4method{[}{ANY,missing,lsparseVector,ANY}(x, i, j, ...) <- value

\S4method{[}{ANY,lsparseVector,missing,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A CSR matrix whose values are to be replaced.}

\item{i}{The indices of the rows to replace.}

\item{j}{The indices of the columns to replace.}

\item{...}{Not used}

\item{value}{The values to replace with.}
}
\value{
The same `x` input with the values `[i,j]` set to `value`.
If the result is a full matrix (e.g. `x[,] <- 1`), the object will
be a dense matrix from base R.
}
\description{
Assign values to a CSR matrix.
Note: this will only be a relatively fast operation when
assigning contiguous row sequences. Only some of the potential
assignment cases to a CSR matrix are replaced here - for example,
cases that involve uneven recycling of vectors will be left to
the `Matrix` package.
}
\examples{
library(Matrix)
library(MatrixExtra)
set.seed(1)
X <- rsparsematrix(5, 3, .5, repr="R")
X[1:3] <- 0
print(X)
}
