% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMI.R
\name{SMI}
\alias{SMI}
\title{Similarity of Matrices Index (SMI)}
\usage{
SMI(X1, X2, ncomp1 = Rank(X1) - 1, ncomp2 = Rank(X2) - 1,
  projection = "Orthogonal", Scores1 = NULL, Scores2 = NULL)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{ncomp1}{maximum number of subspace components from the first \code{matrix}.}

\item{ncomp2}{maximum number of subspace components from the second \code{matrix}.}

\item{projection}{type of projection to apply, defaults to "Orthogonal", alternatively "Procrustes".}

\item{Scores1}{user supplied score-\code{matrix} to replace singular value decomposition of first \code{matrix}.}

\item{Scores2}{user supplied score-\code{matrix} to replace singular value decomposition of second \code{matrix}.}
}
\value{
A matrix containing all combinations of components. Its class is "SMI" associated
with print, plot, summary methods.
}
\description{
A similarity index for comparing coupled data matrices.
}
\details{
A two-step process starts with extraction of stable subspaces using 
Principal Component Analysis or some other method yielding two orthonormal bases. These bases
are compared using Orthogonal Projection (OP / ordinary least squares) or Procrustes
Rotation (PR). The result is a similarity measure that can be adjusted to various
data sets and contexts and which includes explorative plotting and permutation based testing
of matrix subspace equality.
}
\examples{
# Simulation
X1  <- scale( matrix( rnorm(100*300), 100,300), scale = FALSE)
usv <- svd(X1)
X2  <- usv$u[,-3] \%*\% diag(usv$d[-3]) \%*\% t(usv$v[,-3])

(smi <- SMI(X1,X2,5,5))
plot(smi, B = 1000 ) # default B = 10000

# Sensory analysis
data(candy)
plot( SMI(candy$Panel1, candy$Panel2, 3,3, projection = "Procrustes"),
    frame = c(2,2), B = 1000 ) # default B = 10000

}
\author{
Kristian Hovde Liland
}
\references{
Similarity of Matrices Index - Ulf Geir Indahl, Tormod Ns, Kristian Hovde Liland
}
\seealso{
\code{\link{plot.SMI}} (print.SMI/summary.SMI), \code{\link{RV}} (RV2/RVadj), \code{\link{r1}} (r2/r3/r4/GCD), 
\code{\link{allCorrelations}} (matrix correlation comparison), \code{\link{PCAcv} (cross-validated PCA)}.
}

