% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSpecification.R
\name{ModelSpecification}
\alias{ModelSpecification}
\alias{ModelSpecification.default}
\alias{ModelSpecification.formula}
\alias{ModelSpecification.matrix}
\alias{ModelSpecification.ModelFrame}
\alias{ModelSpecification.recipe}
\title{Model Specification}
\usage{
ModelSpecification(...)

\method{ModelSpecification}{default}(
  input,
  model,
  control = MachineShop::settings("control"),
  metrics = NULL,
  cutoff = MachineShop::settings("cutoff"),
  stat = MachineShop::settings("stat.TrainingParams"),
  ...
)

\method{ModelSpecification}{formula}(formula, data, model, ...)

\method{ModelSpecification}{matrix}(x, y, model, ...)

\method{ModelSpecification}{ModelFrame}(input, model, ...)

\method{ModelSpecification}{recipe}(input, model, ...)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods.  The
first argument of each \code{ModelSpecification} method is positional and,
as such, must be given first in calls to them.}

\item{input}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}

\item{model}{\link[=models]{model} function, function name, or object; or
another object that can be \link[=as.MLModel]{coerced} to a model.}

\item{control}{\link[=controls]{control} function, function name, or object
defining the resampling method to be employed.  If \code{NULL} or if
the model specification contains any \code{SelectedInput} or
\code{SelectedModel} objects, then object-specific control structures and
training parameters are used for selection and tuning, as usual, and
objects are trained sequentially with nested resampling.  Otherwise,
\itemize{
  \item tuning of input and model objects is performed simultaneously over
    a global grid of their parameter values, and
  \item the specified \code{control} method and training parameters below
    override those of any included \code{TunedInput} or \code{TunedModel}.
}}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Model
selection is based on the first calculated metric.}

\item{cutoff}{argument passed to the \code{metrics} functions.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for model tuning.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}
}
\value{
\code{ModelSpecification} class object.
}
\description{
Specification of a relationship between response and predictor variables and
a model to define a relationship between them.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

modelspec <- ModelSpecification(
  sale_amount ~ ., data = ICHomes, model = GBMModel
)
fit(modelspec)
}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}},
\code{\link{set_monitor}}, \code{\link{set_optim}}
}
