% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{get_grid}
\alias{get_grid}
\alias{get_grid.default}
\alias{get_grid.formula}
\alias{get_grid.matrix}
\alias{get_grid.ModelFrame}
\alias{get_grid.recipe}
\alias{get_grid.MLModel}
\alias{get_grid.MLModelFunction}
\title{Model Tuning Grid}
\usage{
get_grid(x, ...)

\method{get_grid}{default}(x, ..., model, size = 3, random = FALSE, info = FALSE)

\method{get_grid}{formula}(x, data, ...)

\method{get_grid}{matrix}(x, y, ...)

\method{get_grid}{ModelFrame}(x, ...)

\method{get_grid}{recipe}(x, ...)

\method{get_grid}{MLModel}(x, ...)

\method{get_grid}{MLModelFunction}(x, ...)
}
\arguments{
\item{x}{optional \link[=inputs]{input} specifying a relationship between
model predictor and response variables.  Alternatively, a
\link[=models]{model} function or call may be given first followed by the
input specification.}

\item{...}{arguments passed to the default method.}

\item{model}{\link[=models]{model} function, function name, or call.}

\item{size}{single integer or vector of integers whose positions or names
match the parameters in the model's tuning grid and which specify the
number of values to use in constructing the grid.}

\item{random}{number of unique grid points to sample at random, \code{Inf}
for all random points, or \code{FALSE} for all fixed points.}

\item{info}{logical indicating whether to return the grid construction
information rather than the grid values.}

\item{data}{\link[=data.frame]{data frame} containing observed predictors and
outcomes.}

\item{y}{response variable.}
}
\value{
A data frame of parameter values or \code{NULL} if data are required
for construction of the grid but not supplied.
}
\description{
Extract a model-defined grid of tuning parameter values.
}
\details{
The \code{get_grid} function enables manual extraction and viewing
of grids created automatically if \code{\link{TunedModel}} is called with a
\code{\link{Grid}} object.
}
\examples{
get_grid(GBMModel, size = 10)

get_grid(sale_amount ~ ., data = ICHomes, model = GLMNetModel,
         size = c(lambda = 10, alpha = 5))

}
\seealso{
\code{\link{TunedModel}}, \code{\link{Grid}}
}
