% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff}
\alias{diff}
\alias{diff.MLModelTune}
\alias{diff.Resamples}
\title{Model Performance Differences}
\usage{
\method{diff}{MLModelTune}(x, ...)

\method{diff}{Resamples}(x, ...)
}
\arguments{
\item{x}{object containing resampled metrics.}

\item{...}{arguments to be passed to other methods.}
}
\value{
ResamplesDiff class object that inherits from Resamples.
}
\description{
Pairwise model differences in resampled performance metrics.
}
\examples{
## Survival response example
library(survival)

fo <- Surv(time, status) ~ age + sex + ph.ecog + ph.karno + pat.karno +
                           meal.cal + wt.loss
control <- CVControl()

gbmperf1 <- resample(fo, lung, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, lung, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, lung, GBMModel(n.trees = 100), control)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
perfdiff <- diff(perf)
summary(perfdiff)
plot(perfdiff)

}
\seealso{
\code{\link{plot}}, \code{\link{resample}}, \code{\link{Resamples}},
\code{\link{summary}}, \code{\link{t.test}}
}
