% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsociationRules.R
\name{AssociationRules}
\alias{AssociationRules}
\alias{AsociationRules}
\title{Simple way to obtain data mining rules}
\usage{
AsociationRules(data, Support = 0.2, Confidence = 0.1, minlength = 2)
}
\arguments{
\item{data}{a data frame with discrete variables.}

\item{Support}{a numeric value for the minimun support of the antecedents (default: 0.2).}

\item{Confidence}{a numeric value for the minumun confidence of confidence in rule/association method (default: 0.8)}

\item{minlength}{an integer value for the minimal number of items per item set (default: 2 item)}
}
\value{
A MLA object of subclass AsociationRules
}
\description{
This is a rule-based machine learning method to discover interesting relationships between a consequent and an antecedent (or group of antecedents) in large databases.
}
\examples{
## Load a Dataset
data(EGATUR)
## Generate an asociation rules with apriori, remmember only support discretized variables,
##  in this remove numerical variables.
Rules <- AsociationRules(EGATUR[,c(2,4,5,8)])

}
