% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewPCA.R
\name{viewPCA}
\alias{viewPCA}
\title{fast PCA}
\usage{
viewPCA(
  dat,
  Group = NULL,
  centering = T,
  scaling = "none",
  x = 1,
  y = 2,
  size = 1.5,
  exclude = NULL,
  scale_group = NULL,
  scale_factor = 1,
  interactive = T,
  ...
)
}
\arguments{
\item{dat}{sample ion intensity matrix, row sample, column feature.}

\item{Group}{sample group information}

\item{centering}{centering, default = TRUE}

\item{scaling}{scaling method, default is scaling = "none". You can choose "auto" or "pareto"}

\item{x}{PCA X axis, default is PC1}

\item{y}{PCA Y axis, defult is PC2}

\item{size}{dot size}

\item{exclude}{exclude some classes of samples}

\item{scale_group}{select groups needs to be scaled.}

\item{scale_factor}{the scale factor, default = 1.}

\item{interactive}{should interactive figure be plotted? default = TRUE. If you want to save the result
in high resolution, use non interative plot.}

\item{...}{other parameters}
}
\description{
perform PCA from xcms object
}
\examples{
dat <- matrix(runif(2*300), ncol = 2, nrow = 300)
Group <- rep_len(LETTERS[1:3], 300)
out <- viewPCA(dat, Group = Group)
}
\author{
Yonghui Dong
}
