#include "SingleRegime.h"
#include "gjrGARCH.h"
#include "Normal.h"
#include "Ged.h"
#include "Student.h"
#include "Symmetric.h"
#include "Skewed.h"
//=========================================================================//
//=========================================================================//
//================================== gjrGARCH
//==================================//
//=========================================================================//
//=========================================================================//

typedef SingleRegime<gjrGARCH<Symmetric<Normal> > > gjrGARCH_norm;
typedef SingleRegime<gjrGARCH<Skewed<Normal> > > gjrGARCH_snorm;
typedef SingleRegime<gjrGARCH<Symmetric<Student> > > gjrGARCH_std;
typedef SingleRegime<gjrGARCH<Skewed<Student> > > gjrGARCH_sstd;
typedef SingleRegime<gjrGARCH<Symmetric<Ged> > > gjrGARCH_ged;
typedef SingleRegime<gjrGARCH<Skewed<Ged> > > gjrGARCH_sged;

RCPP_MODULE(gjrGARCH) {
  // gjrGARCH-norm-symmetric
  class_<gjrGARCH_norm>("gjrGARCH_norm")
      .constructor()
      .field("name", &gjrGARCH_norm::name)
      .field("theta0", &gjrGARCH_norm::theta0)
      .field("Sigma0", &gjrGARCH_norm::Sigma0)
      .field("label", &gjrGARCH_norm::label)
      .field("lower", &gjrGARCH_norm::lower)
      .field("upper", &gjrGARCH_norm::upper)
      .field("ineq_lb", &gjrGARCH_norm::ineq_lb)
      .field("ineq_ub", &gjrGARCH_norm::ineq_ub)
      .field("NbParams", &gjrGARCH_norm::NbParams)
      .field("NbParamsModel", &gjrGARCH_norm::NbParamsModel)
      .method("f_sim", &gjrGARCH_norm::f_sim)
      .method("f_pdf", &gjrGARCH_norm::f_pdf)
      .method("f_pdf_its", &gjrGARCH_norm::f_pdf_its)
      .method("f_cdf", &gjrGARCH_norm::f_cdf)
      .method("f_cdf_its", &gjrGARCH_norm::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_norm::f_simAhead)
      .method("f_get_sd", &gjrGARCH_norm::get_sd)
      .method("f_set_sd", &gjrGARCH_norm::set_sd)
      .method("f_get_mean", &gjrGARCH_norm::get_mean)
      .method("f_set_mean", &gjrGARCH_norm::set_mean)
      .method("f_rnd", &gjrGARCH_norm::f_rnd)
      .method("calc_ht", &gjrGARCH_norm::calc_ht)
      .method("eval_model", &gjrGARCH_norm::eval_model)
      .method("ineq_func", &gjrGARCH_norm::ineq_func)
      .method("f_unc_vol", &gjrGARCH_norm::f_unc_vol);
  // gjrGARCH-std-symmetric
  class_<gjrGARCH_std>("gjrGARCH_std")
      .constructor()
      .field("name", &gjrGARCH_std::name)
      .field("theta0", &gjrGARCH_std::theta0)
      .field("Sigma0", &gjrGARCH_std::Sigma0)
      .field("label", &gjrGARCH_std::label)
      .field("lower", &gjrGARCH_std::lower)
      .field("upper", &gjrGARCH_std::upper)
      .field("ineq_lb", &gjrGARCH_std::ineq_lb)
      .field("ineq_ub", &gjrGARCH_std::ineq_ub)
      .field("NbParams", &gjrGARCH_std::NbParams)
      .field("NbParamsModel", &gjrGARCH_std::NbParamsModel)
      .method("f_sim", &gjrGARCH_std::f_sim)
      .method("f_pdf", &gjrGARCH_std::f_pdf)
      .method("f_pdf_its", &gjrGARCH_std::f_pdf_its)
      .method("f_cdf", &gjrGARCH_std::f_cdf)
      .method("f_cdf_its", &gjrGARCH_std::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_std::f_simAhead)
      .method("f_get_sd", &gjrGARCH_std::get_sd)
      .method("f_set_sd", &gjrGARCH_std::set_sd)
      .method("f_get_mean", &gjrGARCH_std::get_mean)
      .method("f_set_mean", &gjrGARCH_std::set_mean)
      .method("f_rnd", &gjrGARCH_std::f_rnd)
      .method("calc_ht", &gjrGARCH_std::calc_ht)
      .method("eval_model", &gjrGARCH_std::eval_model)
      .method("ineq_func", &gjrGARCH_std::ineq_func)
      .method("f_unc_vol", &gjrGARCH_std::f_unc_vol);
  // gjrGARCH-ged-symmetric
  class_<gjrGARCH_ged>("gjrGARCH_ged")
      .constructor()
      .field("name", &gjrGARCH_ged::name)
      .field("theta0", &gjrGARCH_ged::theta0)
      .field("Sigma0", &gjrGARCH_ged::Sigma0)
      .field("label", &gjrGARCH_ged::label)
      .field("lower", &gjrGARCH_ged::lower)
      .field("upper", &gjrGARCH_ged::upper)
      .field("ineq_lb", &gjrGARCH_ged::ineq_lb)
      .field("ineq_ub", &gjrGARCH_ged::ineq_ub)
      .field("NbParams", &gjrGARCH_ged::NbParams)
      .field("NbParamsModel", &gjrGARCH_ged::NbParamsModel)
      .method("f_sim", &gjrGARCH_ged::f_sim)
      .method("f_pdf", &gjrGARCH_ged::f_pdf)
      .method("f_pdf_its", &gjrGARCH_ged::f_pdf_its)
      .method("f_cdf", &gjrGARCH_ged::f_cdf)
      .method("f_cdf_its", &gjrGARCH_ged::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_ged::f_simAhead)
      .method("f_get_sd", &gjrGARCH_ged::get_sd)
      .method("f_set_sd", &gjrGARCH_ged::set_sd)
      .method("f_get_mean", &gjrGARCH_ged::get_mean)
      .method("f_set_mean", &gjrGARCH_ged::set_mean)
      .method("f_rnd", &gjrGARCH_ged::f_rnd)
      .method("calc_ht", &gjrGARCH_ged::calc_ht)
      .method("eval_model", &gjrGARCH_ged::eval_model)
      .method("ineq_func", &gjrGARCH_ged::ineq_func)
      .method("f_unc_vol", &gjrGARCH_ged::f_unc_vol);

  // gjrGARCH-norm-skew
  class_<gjrGARCH_snorm>("gjrGARCH_snorm")
      .constructor()
      .field("name", &gjrGARCH_snorm::name)
      .field("theta0", &gjrGARCH_snorm::theta0)
      .field("Sigma0", &gjrGARCH_snorm::Sigma0)
      .field("label", &gjrGARCH_snorm::label)
      .field("lower", &gjrGARCH_snorm::lower)
      .field("upper", &gjrGARCH_snorm::upper)
      .field("ineq_lb", &gjrGARCH_snorm::ineq_lb)
      .field("ineq_ub", &gjrGARCH_snorm::ineq_ub)
      .field("NbParams", &gjrGARCH_snorm::NbParams)
      .field("NbParamsModel", &gjrGARCH_snorm::NbParamsModel)
      .method("f_sim", &gjrGARCH_snorm::f_sim)
      .method("f_pdf", &gjrGARCH_snorm::f_pdf)
      .method("f_pdf_its", &gjrGARCH_snorm::f_pdf_its)
      .method("f_cdf", &gjrGARCH_snorm::f_cdf)
      .method("f_cdf_its", &gjrGARCH_snorm::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_snorm::f_simAhead)
      .method("f_get_sd", &gjrGARCH_snorm::get_sd)
      .method("f_set_sd", &gjrGARCH_snorm::set_sd)
      .method("f_get_mean", &gjrGARCH_snorm::get_mean)
      .method("f_set_mean", &gjrGARCH_snorm::set_mean)
      .method("f_rnd", &gjrGARCH_snorm::f_rnd)
      .method("calc_ht", &gjrGARCH_snorm::calc_ht)
      .method("eval_model", &gjrGARCH_snorm::eval_model)
      .method("ineq_func", &gjrGARCH_snorm::ineq_func)
      .method("f_unc_vol", &gjrGARCH_snorm::f_unc_vol);
  // gjrGARCH-std-skew
  class_<gjrGARCH_sstd>("gjrGARCH_sstd")
      .constructor()
      .field("name", &gjrGARCH_sstd::name)
      .field("theta0", &gjrGARCH_sstd::theta0)
      .field("Sigma0", &gjrGARCH_sstd::Sigma0)
      .field("label", &gjrGARCH_sstd::label)
      .field("lower", &gjrGARCH_sstd::lower)
      .field("upper", &gjrGARCH_sstd::upper)
      .field("ineq_lb", &gjrGARCH_sstd::ineq_lb)
      .field("ineq_ub", &gjrGARCH_sstd::ineq_ub)
      .field("NbParams", &gjrGARCH_sstd::NbParams)
      .field("NbParamsModel", &gjrGARCH_sstd::NbParamsModel)
      .method("f_sim", &gjrGARCH_sstd::f_sim)
      .method("f_pdf", &gjrGARCH_sstd::f_pdf)
      .method("f_pdf_its", &gjrGARCH_sstd::f_pdf_its)
      .method("f_cdf", &gjrGARCH_sstd::f_cdf)
      .method("f_cdf_its", &gjrGARCH_sstd::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_sstd::f_simAhead)
      .method("f_get_sd", &gjrGARCH_sstd::get_sd)
      .method("f_set_sd", &gjrGARCH_sstd::set_sd)
      .method("f_get_mean", &gjrGARCH_sstd::get_mean)
      .method("f_set_mean", &gjrGARCH_sstd::set_mean)
      .method("f_rnd", &gjrGARCH_sstd::f_rnd)
      .method("calc_ht", &gjrGARCH_sstd::calc_ht)
      .method("eval_model", &gjrGARCH_sstd::eval_model)
      .method("ineq_func", &gjrGARCH_sstd::ineq_func)
      .method("f_unc_vol", &gjrGARCH_sstd::f_unc_vol);
  // gjrGARCH-ged-skew
  class_<gjrGARCH_sged>("gjrGARCH_sged")
      .constructor()
      .field("name", &gjrGARCH_sged::name)
      .field("theta0", &gjrGARCH_sged::theta0)
      .field("Sigma0", &gjrGARCH_sged::Sigma0)
      .field("label", &gjrGARCH_sged::label)
      .field("lower", &gjrGARCH_sged::lower)
      .field("upper", &gjrGARCH_sged::upper)
      .field("ineq_lb", &gjrGARCH_sged::ineq_lb)
      .field("ineq_ub", &gjrGARCH_sged::ineq_ub)
      .field("NbParams", &gjrGARCH_sged::NbParams)
      .field("NbParamsModel", &gjrGARCH_sged::NbParamsModel)
      .method("f_sim", &gjrGARCH_sged::f_sim)
      .method("f_pdf", &gjrGARCH_sged::f_pdf)
      .method("f_pdf_its", &gjrGARCH_sged::f_pdf_its)
      .method("f_cdf", &gjrGARCH_sged::f_cdf)
      .method("f_cdf_its", &gjrGARCH_sged::f_cdf_its)
      .method("f_simAhead", &gjrGARCH_sged::f_simAhead)
      .method("f_get_sd", &gjrGARCH_sged::get_sd)
      .method("f_set_sd", &gjrGARCH_sged::set_sd)
      .method("f_get_mean", &gjrGARCH_sged::get_mean)
      .method("f_set_mean", &gjrGARCH_sged::set_mean)
      .method("f_rnd", &gjrGARCH_sged::f_rnd)
      .method("calc_ht", &gjrGARCH_sged::calc_ht)
      .method("eval_model", &gjrGARCH_sged::eval_model)
      .method("ineq_func", &gjrGARCH_sged::ineq_func)
      .method("f_unc_vol", &gjrGARCH_sged::f_unc_vol);
}
