% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_definitions.R
\docType{class}
\name{Obs-class}
\alias{Obs-class}
\title{Class \code{'Obs'}}
\description{
An operating model component that controls the observation model
}
\section{Slots}{

\describe{
\item{\code{Name}}{The name of the observation model object. Single value. Character string.}

\item{\code{Name}}{The name of the Observation error object. Single value. Character
string.}

\item{\code{Cobs}}{Observation error around the total catch. Observation error in
the total catch is expressed as a coefficient of variation (CV). Cobs requires
upper and lower bounds of a uniform distribution, and for each simulation a CV
is sampled from this distribution. Each CV is used to specify a log-normal
error distribution with a mean of 1 and a standard deviation equal to the
sampled CV. The yearly observation error values for the catch data are then
drawn from this distribution. For each time step the simulation model records
the true catch, but the observed catch is generated by applying this yearly
error term (plus any bias, if specified) to the true catch.}

\item{\code{Cbiascv}}{Log-normally distributed coefficient of variation controlling
the sampling bias in observed catch for each simulation. Bias occurs when
catches are systematically skewed away from the true catch level (for example,
due to underreporting of catch or undetected illegal catches). Cbiascv is a
single value specifying the standard deviation of a log-normal distribution
with a mean of 1 and a standard deviation equal to the sampled CV. For each
simulation a bias value is drawn from this distribution, and that bias is
applied across all years.}

\item{\code{CAA_nsamp}}{Number of catch-at-age observations collected per time step.
For each time step a single value is drawn from a uniform distribution
specified by the upper and lower bounds provided. Positive integers.}

\item{\code{CAA_ESS}}{Effective sample size of catch-at-age observations collected
per time step. For each time step a single value is drawn from a uniform
distribution specified by the upper and lower bounds provided. CAA_ESS should
not exceed CAA_nsamp. If greater than 1, then this is the multinomial
distribution sample size. If less than 1, this is the coefficient of variation
for the logistic normal distribution (see help doucmentation for simCAA for
details).}

\item{\code{CAL_nsamp}}{Number of catch-at-length observations collected per time
step. For each time step a single value is drawn from a uniform distribution
specified by the upper and lower bounds provided. Positive integers.}

\item{\code{CAL_ESS}}{Effective sample size. For each time step a single value is
drawn from a uniform distribution specified by the upper and lower bounds
provided. CAL_ESS should not exceed CAL_nsamp. Positive integers.}

\item{\code{Iobs}}{Observation error in the relative abundance index expressed as a
coefficient of variation (CV). Iobs requires upper and lower bounds of a
uniform distribution, and for each simulation a CV is sampled from this
distribution. Each CV is used to specify a log-normal error distribution with a
mean of 1 and a standard deviation equal to the sampled CV. The yearly
observation error values for the index of abundance data are then drawn from
this distribution. For each time step the simulation model records the true
change in abundance, but the observed index is generated by applying this
yearly error term (plus any bias, if specified) to the true relative change in
abundance. Positive real numbers.}

\item{\code{Btobs}}{Observation error in the absolute abundance expressed as a
coefficient of variation (CV). Btobs requires upper and lower bounds of a
uniform distribution, and for each simulation a CV is sampled from this
distribution. Each CV is used to specify a log-normal error distribution with a
mean of 1 and a standard deviation equal to the sampled CV. The yearly
observation error values for the absolute abundance data are then drawn from
this distribution. For each time step the simulation model records the true
abundance, but the observed abundance is generated by applying this yearly
error term (plus any bias, if specified) to the true abundance. Positive real
numbers.}

\item{\code{Btbiascv}}{Log-normally distributed coefficient (CV) controlling error
in observations of the current stock biomass. Bias occurs when the observed
index of abundance is is systematically higher or lower than the true relative
abundance. Btbiascv is a single value specifying the standard deviation of a
log-normal distribution with a mean of 1 and a standard deviation equal to the
sampled CV. For each simulation a bias value is drawn from this distribution,
and that bias is applied across all years. Positive real numbers.}

\item{\code{beta}}{A parameter controlling hyperstability/hyperdepletion in the
measurement of abundance. For each simulation a single value is drawn from a
uniform distribution specified by the upper and lower bounds provided. Values
below 1 lead to hyperstability (the observed index decreases more slowly than
the true abundance) and values above 1 lead to hyperdepletion (the observed
index decreases more rapidly than true abundance).  Positive real numbers.}

\item{\code{LenMbiascv}}{Log-normal coefficient of variation for sampling bias in
observed length at 50 percent maturity. LenMbiascv is a single value specifying
the standard deviation of a log-normal distribution with a mean of 1 and a
standard deviation equal to the sampled CV. For each simulation a bias value is
drawn from this distribution, and that bias is applied across all years.
Positive real numbers.}

\item{\code{Mbiascv}}{Log-normal coefficient of variation for sampling bias in
observed natural mortality rate.
Mbiascv is a single value specifying the standard deviation of a log-normal
distribution with a mean of 1 and a standard deviation equal to the sampled CV.
For each simulation a bias value is drawn from this distribution, and that bias
is applied across all years. Positive real numbers.}

\item{\code{Kbiascv}}{Log-normal coefficient of variation for sampling bias in
observed growth parameter K. Kbiascv is a single value specifying the standard
deviation of a log-normal distribution with a mean of 1 and a standard
deviation equal to the sampled CV. For each simulation a bias value is drawn
from this distribution, and that bias is applied across all years. Positive
real numbers.}

\item{\code{t0biascv}}{Log-normal coefficient of variation for sampling bias in
observed t0. t0biascv is a single value specifying the standard deviation of a
log-normal distribution with a mean of 1 and a standard deviation equal to the
sampled CV. For each simulation a bias value is drawn from this distribution,
and that bias is applied across all years. Positive real numbers.}

\item{\code{Linfbiascv}}{Log-normal coefficient of variation for sampling bias in
observed maximum length. Linfbiascv is a single value specifying the standard
deviation of a log-normal distribution with a mean of 1 and a standard
deviation equal to the sampled CV. For each simulation a bias value is drawn
from this distribution, and that bias is applied across all years. Positive
real numbers.}

\item{\code{LFCbiascv}}{Log-normal coefficient of variation for sampling bias in
observed length at first capture. LFCbiascv is a single value specifying the
standard deviation of a log-normal distribution with a mean of 1 and a standard
deviation equal to the sampled CV. For each simulation a bias value is drawn
from this distribution, and that bias is applied across all years. Positive
real numbers.}

\item{\code{LFSbiascv}}{Log-normal coefficient of variation for sampling bias in
length-at-full selection. LFSbiascv is a single value specifying the standard
deviation of a log-normal distribution with a mean of 1 and a standard
deviation equal to the sampled CV. For each simulation a bias value is drawn
from this distribution, and that bias is applied across all years. Positive
real numbers.}

\item{\code{FMSY_Mbiascv}}{Log-normal coefficient of variation for sampling bias in
estimates of the ratio of the fishing mortality rate that gives the maximum
sustainable yield relative to the assumed instantaneous natural mortality rate.
FMSY/M. FMSY_Mbiascv is a single value specifying the standard deviation of a
log-normal distribution with a mean of 1 and a standard deviation equal to the
sampled CV. For each simulation a bias value is drawn from this distribution,
and that bias is applied across all years. Positive real numbers.}

\item{\code{BMSY_B0biascv}}{Log-normal coefficient of variation for sampling bias in
estimates of the BMSY relative to unfished biomass (BMSY/B0). BMSY_B0biascv is
a single value specifying the standard deviation of a log-normal distribution
with a mean of 1 and a standard deviation equal to the sampled CV. For each
simulation a bias value is drawn from this distribution, and that bias is
applied across all years. Positive real numbers.}

\item{\code{Irefbiascv}}{Log-normal coefficient of variation for sampling bias in
the observed relative index of abundance (Iref). Irefbiascv is a single value
specifying the standard deviation of a log-normal distribution with a mean of 1
and a standard deviation equal to the sampled CV. For each simulation a bias
value is drawn from this distribution, and that bias is applied across all
years. Positive real numbers.}

\item{\code{Brefbiascv}}{Log-normal coefficient of variation for sampling bias in
the observed reference biomass (Bref). Brefbiascv is a single value specifying
the standard deviation of a log-normal distribution with a mean of 1 and a
standard deviation equal to the sampled CV. For each simulation a bias value is
drawn from this distribution, and that bias is applied across all years.
Positive real numbers.}

\item{\code{Crefbiascv}}{Log-normal coefficient of variation for sampling bias in
the observed reference catch (Cref). Crefbiascv is a single value specifying
the standard deviation of a log-normal distribution with a mean of 1 and a
standard deviation equal to the sampled CV. For each simulation a bias value is
drawn from this distribution, and that bias is applied across all years.
Positive real numbers.}

\item{\code{Dbiascv}}{Log-normal coefficient of variation for sampling bias in the
observed depletion level.  Dbiascv is a single value specifying the standard
deviation of a log-normal distribution with a mean of 1 and a standard
deviation equal to the sampled CV. For each simulation a bias value is drawn
from this distribution, and that bias is applied across all years. Positive
real numbers.}

\item{\code{Dobs}}{Log-normal coefficient of variation controlling error in
observations of stock depletion among years. Observation error in the depletion
expressed as a coefficient of variation (CV). Dobs requires the upper and lower
bounds of a uniform distribution, and for each simulation a CV is sampled from
this distribution. Each CV is used to specify a log-normal error distribution
with a mean of 1 and a standard deviation equal to the sampled CV. The yearly
observation error values for the depletion data are then drawn from this
distribution. For each time step the simulation model records the true
depletion, but the observed depletion is generated by applying this yearly
error term (plus any bias, if specified) to the true depletion.}

\item{\code{hbiascv}}{Log-normal coefficient of variation for sampling persistent
bias in steepness. hbiascv is a single value specifying the standard deviation
of a log-normal distribution with a mean of 1 and a standard deviation equal to
the sampled CV. For each simulation a bias value is drawn from this
distribution, and that bias is applied across all years. Positive real numbers.}

\item{\code{Recbiascv}}{Log-normal coefficient of variation for sampling persistent
bias in recent recruitment strength. Recbiascv requires the upper and lower
bounds of a uniform distribution, and for each simulation a CV is sampled from
this distribution. Each CV is used to specify a log-normal error distribution
with a mean of 1 and a standard deviation equal to the sampled CV. The yearly
bias values for the depletion data are then drawn from this distribution.
Positive real numbers.}

\item{\code{sigmaRbiascv}}{Log-normal coefficient of variation for sampling
persistent bias in recruitment variability. sigmaRbiascv is a single value
specifying the standard deviation of a log-normal distribution with a mean of 1
and a standard deviation equal to the sampled CV. For each simulation a bias
value is drawn from this distribution, and that bias is applied across all
years. Positive real numbers.}

\item{\code{Eobs}}{Observation error around the total effort. Observation error in
the total effort is expressed as a coefficient of variation (CV). Eobs requires
upper and lower bounds of a uniform distribution, and for each simulation a CV
is sampled from this distribution. Each CV is used to specify a log-normal
error distribution with a mean of 1 and a standard deviation equal to the
sampled CV. The yearly observation error values for the effort data are then
drawn from this distribution. For each time step the simulation model records
the true effort, but the observed effort is generated by applying this yearly
error term (plus any bias, if specified) to the true effort.}

\item{\code{Ebiascv}}{Log-normally distributed coefficient of variation controlling
the sampling bias in observed effort for each simulation. Bias occurs when
effort is systematically skewed away from the true effort level. Ebiascv is a
single value specifying the standard deviation of a log-normal distribution
with a mean of 1 and a standard deviation equal to the sampled CV. For each
simulation a bias value is drawn from this distribution, and that bias is
applied across all years.}
}}

\note{
Its questionable whether the hyperstability/hyperdepletion should be
categorised as an observation model characteristic as it is most often
driven by fleet dynamics (and therefore should be in the fleet object). Oh
well its here and you might want to make it hyperstable beta < 1 or
hyperdeplete beta > 1, only.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Obs')}
}

\examples{

showClass('Obs')

}
\author{
T. Carruthers and A. Hordyk
}
\keyword{classes}
