% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MICE_Rel.R
\name{makeRel}
\alias{makeRel}
\alias{print.Rel}
\alias{predict.Rel}
\alias{simulate.Rel}
\title{MICE relationships for multi-OM}
\usage{
makeRel(type = "DDM", stock = 1, CV = 0, ...)

\method{print}{Rel}(x, ...)

\method{predict}{Rel}(object, newdata, ...)

\method{simulate}{Rel}(object, nsim = 1, seed = 1, ...)
}
\arguments{
\item{type}{String to indicate the type of stock interaction. \code{"DDM"} for
density-dependent natural mortality.}

\item{stock}{The index position of the stock in the MOM.}

\item{CV}{Coefficient of variation of the predicted value for \code{simulate}. Used to pass
values to the operating model.}

\item{...}{Additional arguments depending on \code{type}. See details below.}

\item{x}{For \code{print.Rel}, a \code{Rel} class object from \code{make_Rel}.}

\item{object}{A \code{Rel} class object from \code{make_Rel}.}

\item{newdata}{A data frame to provide values of predictor variables with which to calculate the
response variable.}

\item{nsim}{The number of simulations.}

\item{seed}{Integer to specify the seed for the random number generator.}
}
\value{
A class "Rel" object to pass to \code{MOM@Rel}.
}
\description{
Generate a MICE \code{Rel} object, with \code{predict} and \code{simulate} methods, for \link{multiMSE}.
Currently implements intra-stock dynamics via density-dependent processes.
}
\section{Density-dependent M ("DDM")}{

Natural mortality (M) is a linear function of stock depletion in terms to total biomass (B) in year y
(Forrest et al. 2018):
\deqn{M_y = M_0 + (M_1 + M_0) (1 - B_y/B_0)}{M_y = M_0 + (M_1 + M_0) (1 - B_y/B_0)}
with a constraint that \eqn{M_y = M_0} if \eqn{B_y > B_0}

Provide the following arguments:
\itemize{
\item \code{M0}: Natural mortality as B approaches B0. Vector \verb{[nsim]}
\item \code{M1}: Natural mortality as B approaches zero. Vector \verb{[nsim]}
\item Optional \code{B0}: Unfished biomass. Calculated from stock-recruit \code{alpha} and \code{beta} and unfished
biomass per recruit at M = M0. Vector \verb{[nsim]}
}
}

\examples{
# Depensatory natural mortality
Rel <- makeRel(type = "DDM", M0 = 0.8, M1 = 0.2, CV = 0.1)

# Predict M when B/B0 = 0.1
pred <- predict(Rel, newdata = data.frame(B_1 = 0.1, B0_1 = 1))

# Simulate values of M with CV = 0.1
Rel$fitted.values <- pred
simulate(Rel, nsim = 10, seed = 1)

# Add Rel to MOM
MOM <- makeMOM(testOM)
MOM@Rel <- list(Rel)
}
\references{
Forrest, R., Holt, K., and Kronlund, A. 2018. Performance of alternative harvest control rules for two
Pacific groundfish stocks with uncertain natural mortality: Bias, robustness and trade-offs.
Fisheries Research 206: 259–286. \doi{10.1016/j.fishres.2018.04.007}
}
\author{
Q. Huynh
}
