% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_steepness}
\alias{plot_steepness}
\title{Plots probability distribution function of stock-recruit steepness}
\usage{
plot_steepness(m, sd, is_transform = FALSE, SR = c("BH", "Ricker"),
  color = "black")
}
\arguments{
\item{m}{The mean of the distribution (vectorized).}

\item{sd}{The standard deviation of the distribution (vectorized).}

\item{is_transform}{Logical, whether the mean and standard deviation are in normal space
(FALSE) or transformed space.}

\item{SR}{The stock recruitment relationship (determines the range and, if relevant, transformation of
steepness).}

\item{color}{A vector of colors.}
}
\value{
A plot of the probability distribution function. Vertical dotted line
indicates mean of distribution.
}
\description{
Plots the probability distribution function of steepness from the
mean and standard deviation.
}
\note{
The function samples from a beta distribution with parameters alpha and beta
that are converted from the mean and standard deviation. Then, the distribution is
transformed from 0 - 1 to 0.2 - 1.
}
\examples{
mu <- DLMtool::Simulation_1@steep
stddev <- DLMtool::Simulation_1@steep * DLMtool::Simulation_1@CV_steep
plot_steepness(mu, stddev)
}
\seealso{
\code{\link{plot_lognormalvar}} \code{\link{plot_betavar}}
}
\author{
Q. Huynh
}
