% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_VPA.R
\name{VPA}
\alias{VPA}
\title{Virtual population analysis (VPA)}
\usage{
VPA(x = 1, Data, expanded = FALSE, SR = c("BH", "Ricker"),
  vulnerability = c("logistic", "dome", "free"), I_type = c("B", "VB",
  "SSB"), rescale = "mean1", start = NULL, fix_h = TRUE,
  fix_sigma = FALSE, fix_Fratio = TRUE, vul_pen = c(3, 0.4),
  R_pen = c(3, Data@sigmaR[x]), nitF = 5L, silent = TRUE,
  opt_hess = FALSE, n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 2e+05, eval.max = 4e+05), ...)
}
\arguments{
\item{x}{A position in the Data object (by default, equal to one for assessments).}

\item{Data}{An object of class Data}

\item{expanded}{Whether the catch at age in \code{Data} has been expanded. If \code{FALSE}, then the catch in weight
should be provided in \code{Data@Cat} so that the function can calculate annual expansion factors.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}) for calculating MSY reference points.}

\item{vulnerability}{Whether the terminal year vulnerability is \code{"logistic"} or \code{"dome"} (double-normal). If \code{"free"},
independent F's are calculated in the terminal year (subject to the assumed ratio of F of the plus-group to the previous age class).
See details for parameterization.}

\item{I_type}{Whether the index surveys population biomass (B; this is the default in the DLMtool operating model),
vulnerable biomass (VB), or spawning stock biomass (SSB).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep}. This only affects
calculation of reference points.}

\item{fix_sigma}{Logical, whether the standard deviation of the index is fixed. If \code{TRUE},
sigma is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Ind}.}

\item{fix_Fratio}{Logical, whether the ratio of F of the plus-group to the previous age class is fixed in the model.}

\item{vul_pen}{A length two vector that parameterizes how the model constrains the vulnerability in the most recent years. The first number
is the number of years in which vulnerability will be constrained (as a random walk), the second number is the standard deviation of the random walk.}

\item{R_pen}{A length two vector that parameterizes how the model constrains the recruitment in the most recent years. The first number
is the number of years in which recruitment will be constrained (as a random walk), the second number is the standard deviation of the random walk.}

\item{nitF}{The number of iterations for solving F in the model (via Newton's method).}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for dignostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of agruments for optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{...}{Other arguments to be passed.}
}
\value{
An object of class \linkS4class{Assessment}. The F vector is the apical fishing mortality experienced by any
age class in a given year. The U vector is the ratio of catch (weight) and vulnerable biomass, which may be a better
description of fishing pressure (and UMSY = MSY/VBMSY).
}
\description{
A VPA model that back-calculates abundance-at-age assuming that the catch-at-age is known without error and tuned to an index.
The population dynamics equations are primarily drawn from VPA-2BOX (Porch 2018). MSY reference points are then calculated from the
VPA output.
}
\details{
The VPA is initialized by estimating the terminal F-at-age. Parameter \code{F_term} is the apical terminal F if
a functional form for vulnerability is used in the terminal year. If the terminal F-at-age are otherwise independent parameters,
\code{F_term} is the F for the reference age which is half the maximum age. Once terminal-year abundance is
estimated, the abundance in historical years can be back-calculated. The oldest age group is a plus-group, and requires
an assumption regarding the ratio of F's between the plus-group and the next youngest age class. The F-ratio can
be fixed (default) or estimated.



For \code{start} (optional), a named list of starting values of estimates can be provided for:
\itemize{
\item \code{F_term} The terminal year fishing mortality.
\item \code{F_ratio} The ratio of F in the plus-group to the next youngest age. If not provided, a value of 1 is used.
\item \code{vul_par} Vulnerability parameters in the terminal year. This will be of length 2 vector for \code{"logistic"} or length 4 for
\code{"dome"}, see \link{SCA} for further documentation on parameterization. For option \code{"free"}, this will be a vector of length
A-2 where A is the number of age classes in the model. To estimate parameters, vulnerability is initially set to one at half the max age
(and subsequently re-calculated relative to the maximum F experienced in that year). Vulnerability in the plus-group is also constrained
by the Fratio.
\item \code{sigma} Standard deviation of the index. If not provided, the value based on \code{Data@CV_Ind} is used.
}
}
\references{
Porch, C.E. 2018. VPA-2BOX 4.01 User Guide. NOAA Tech. Memo. NMFS-SEFSC-726. 67 pp.
}
