% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_SRA.R
\docType{class}
\name{SRA-class}
\alias{SRA-class}
\alias{SRA}
\title{Class-\code{SRA}}
\description{
An S4 class for the output from \link{SRA_scope}.
}
\section{Slots}{

\describe{
\item{\code{OM}}{An updated operating model, class \linkS4class{OM}.}

\item{\code{SSB}}{An matrix of estimated spawning biomass with \code{OM@nsim} rows and \code{OM@nyears+1} columns.}

\item{\code{NAA}}{An array for the predicted numbers at age with dimension \code{OM@nsim}, \code{OM@nyears+1}, and \code{OM@maxage}.}

\item{\code{CAA}}{An array for the predicted catch at age with dimension \code{OM@nsim}, \code{OM@nyears}, \code{OM@maxage}, and nfleet.}

\item{\code{CAL}}{An array for the predicted catch at length with dimension \code{OM@nsim}, \code{OM@nyears}, length bins, and nfleet.}

\item{\code{conv}}{A logical vector of length \code{OM@nsim} indicating convergence of the SRA scoping model in the i-th simulation.}

\item{\code{Misc}}{A list of length \code{OM@nsim} with more output from the fitted SRA scoping model.}

\item{\code{mean_fit}}{A list of output from fit to mean values of life history parameters in the operating model.}

\item{\code{data}}{A list of the data inputs for the SRA scoping model.}

\item{\code{config}}{A data frame describing configuration of the SRA scoping model.}
}}

\seealso{
\link{plot.SRA} \link{SRA_scope}
}
\author{
Q. Huynh
}
