% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Movement_calcs.R
\name{simmov}
\alias{simmov}
\alias{plot_mov}
\title{Calculates movement matrices from user inputs}
\usage{
simmov(OM, dist = c(0.1, 0.2, 0.3, 0.4), prob = 0.5, distE = 0.1,
  probE = 0.1, prob2 = NA, figure = TRUE)

plot_mov(mov, age = 1, type = c("matrix", "all"))
}
\arguments{
\item{OM}{Operating model, an object of class \linkS4class{OM}.}

\item{dist}{A vector of fractions of unfished stock in each area. The length of this vector will determine the number of areas (\code{nareas}) in the OM.}

\item{prob}{Mean probability of staying across all areas (single value) or a vector of the probability of individuals staying in each area (same length as dist)}

\item{distE}{Logit (normal) St.Dev error for sampling stock fractions from the fracs vector}

\item{probE}{Logit (normal) St.Dev error for sampling desired probability of staying either by area (prob is same length as dist) or the mean probability of staying (prob is a single number)}

\item{prob2}{Optional vector as long as prob and dist. Upper bounds on uniform sampling of probability of staying, lower bound is prob.}

\item{figure}{Logical to indicate if the movement matrix will be plotted (mean values and range across \code{OM@nsim} simulations.)}

\item{mov}{A four-dimensional array of dimension \code{c(nsim, maxage, nareas, nareas)}
specifying movement in the operating model.}

\item{age}{An age from 1 to maxage for the movement-at-age matrix figure when \code{type = "matrix"}.}

\item{type}{Whether to plot a movement matrix for a single age (\code{"matrix"}) or the full movement versus age figure (\code{"all"})}
}
\value{
The operating model \code{OM} with movement parameters in slot \code{cpars}.
The \code{mov} array is of dimension \code{nsim}, \code{maxage}, \code{nareas}, \code{nareas}.
}
\description{
A wrapper function for \link{makemov} used to generate movement matrices for a DLMtool operating model.
Calculates a movement matrix from user-specified unfished stock biomass fraction in each area and probability of staying in the area in each time step.
}
\section{Functions}{
\itemize{
\item \code{simmov}: Estimation function for creating movement matrix.

\item \code{plot_mov}: Plotting function.
}}

\note{
Array \code{mov} is age-specific, but currently the movement generated by \code{simmov} is independent of age.
}
\examples{
\donttest{
movOM_5areas <- simmov(testOM, dist = c(0.01,0.1,0.2,0.3,0.39), prob = c(0.1,0.6,0.6,0.7,0.9))
movOM_5areas@cpars$mov[1, 1, , ] # sim 1, age 1, movement from areas in column i to areas in row j
plot_mov(movOM_5areas@cpars$mov)
plot_mov(movOM_5areas@cpars$mov, type = "all")
}
}
\author{
T. Carruthers and Q. Huynh
}
