% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{fitCycleOrders}
\alias{fitCycleOrders}
\title{Compute fit of circular orders to distance with least squares}
\usage{
fitCycleOrders(D, E, orders)
}
\arguments{
\item{D}{an empirical distance table}

\item{E}{an expected distance table, to be reordered}

\item{orders}{a vector indicating an order, or matrix whose rows give orders, to fit}
}
\value{
vector of RSSs, one for each order
}
\description{
Compute residual sum of squares (RSS) comparing empirical distance for a blob
to an expected one for a cycle with each given order/designated hybrid. This is used
in NANAUQ+ commands for resolving multifurcations in a tree of blobs to a cycle
}
\seealso{
\code{\link{resolveCycle}}, \code{\link{resolveLevel1}}
}
