% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppratio.r
\name{ppratio}
\alias{ppratio}
\title{Post-pre-(r)mspe-ratios for placebo studies}
\usage{
ppratio(
  x,
  what,
  range.pre,
  range.post,
  type = c("rmspe", "mspe"),
  return.all = FALSE
)
}
\arguments{
\item{x}{An object of class \code{"mscmt"}, usually obtained as
the result of a call to function \code{\link{mscmt}}.}

\item{what}{A character vector. Name of the variable to be considered. If 
missing, the (first) dependent variable will be used.}

\item{range.pre}{A vector of length 2 defining the range of the pre-treatment
period with start and end time given as 
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd" with "?"
different from "W" (see below), e.g. "2016/03" or "2016-10",
\item weekly dates, if the format of start/end time is "ddddWdd", e.g. 
"2016W23",
\item daily dates, if the format of start/end time is "dddd-dd-dd", e.g. 
"2016-08-18",
}
corresponding to the format of the respective column of the \code{times.dep}
argument of \code{\link{mscmt}}.
If missing, the corresponding column of \code{times.dep} will be used.}

\item{range.post}{A vector of length 2 defining the range of the 
post-treatment period with start and end time given as 
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd" with "?"
different from "W" (see below), e.g. "2016/03" or "2016-10",
\item weekly dates, if the format of start/end time is "ddddWdd", e.g. 
"2016W23",
\item daily dates, if the format of start/end time is "dddd-dd-dd", e.g. 
"2016-08-18",
}
corresponding to the format of the respective column of the \code{times.dep}
argument of \code{\link{mscmt}}. Will be guessed if missing.}

\item{type}{A character string. Either \code{rmspe} (default) or \code{mspe}.
Selects whether root mean squared errors or mean squared errors are 
calculated.}

\item{return.all}{A logical scalar. If \code{FALSE} (default), only the
(named) vector of post-pre-(r)mspe-ratios is returned, if \code{TRUE},
a three-column matrix with pre- and post-treatment (r)mspe's as well as the 
post-pre-ratios will be returned.}
}
\value{
If \code{return.all} is \code{FALSE}, a (named) vector of 
post-pre-(r)mspe-ratios. If \code{return.all} is \code{TRUE}, a matrix with
three columns containing the pre-treatment (r)mspe, the post-treatment 
(r)mspe, and the post-pre-ratio.
}
\description{
\code{ppratio} calculates post-to-pre-(r)mspe-ratios for placebo studies.
}
\details{
\code{ppratio} calculates post-to-pre-(r)mspe-ratios for placebo studies based
on Synthetic Control Methods.
}
