% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{negLLP}
\alias{negLLP}
\title{negLLP  -ve log-likelihood for normally distributed variables}
\usage{
negLLP(
  pars,
  funk,
  indat,
  logobs,
  initpar = pars,
  notfixed = c(1:length(pars)),
  ...
)
}
\arguments{
\item{pars}{a vector containing the log-transformed parameters being 
used in funk, plus an extra sigma which is the standard deviation of 
the log-normal random likelihoods in dnorm}

\item{funk}{the function name that calculates the predicted values from
the independent values}

\item{indat}{the data.frame that contains the data used by the input funk}

\item{logobs}{the log-transformed observed values for comparison with the
values that the model will predict for each of the independent values}

\item{initpar}{this defaults to the same as pars - using all parameters}

\item{notfixed}{a vector identifying the indices of the parameters to be
fitted, which also defines those that will be fixed; defaults
to all parameters set to vary. If some need to be kept constant 
so as to generate a likelihood profile then omit their index from 
'notfixed'.}

\item{...}{required to allow funk to access its other parameters without
having to explicitly declare them in negLL}
}
\value{
the sum of the negative log-likelihoods using a normal PDF
}
\description{
negLLP calculates the negative log-likelihood for normally
    distributed variables allowing for some parameters to reamin fiuxed. 
    It assumes the presence of a function 'funk' that will calculate 
    predicted values of a dependent variable from a vector of 
    independent values (logobs). By having a separate vector of 
    parameters in 'initpar' and a vector of the indices of those 
    parameters that will be fitted (notfixed) it is possible to fit 
    only a subset of parameters. This is useful, for example, if 
    generating a likelihood profile, or setting up a likelihood 
    ratio test. With more complex models it is often a useful 
    strategy to estimate the full number of parameters in a 
    sequence of phases, increasing the number being estimated each 
    time while keeping the rest fixed. 'negLLP' makes such phasing 
    of the fitting of a model to data possible.
    This function can be applied directly to log-transformed data for 
    log-normally distributed data, in which case funk would need to 
    generate log-transformed values. But can also be applied to 
    normally distributed data, in which case one would not 
    log-transform the data being input to the logobs argument and funk 
    would generated the linear-space predicted values.
    
    The selection of which parameters to vary is simply implemented 
    through repeatedly copying the original input values from initpar
    and then changing those notfixed from the varying par values
}
\examples{
 data(abdat)
 param <- log(c(r= 0.42,K=9400,Binit=3400,sigma=0.05)) 
 optmod <- nlm(f=negLLP,p=param,funk=simpspm,initpar=param,
              notfixed=c(1,2,3,4),indat=abdat,logobs=log(abdat$cpue))
 outfit(optmod,backtran= TRUE) #backtran=TRUE is default anyway
  
 rval <- seq(0.325,0.45,0.0125)  # set up the test sequence
 columns <- c("r","K","Binit","sigma","-veLL")
 result <- matrix(0,nrow=11,ncol=5,dimnames=list(rval,columns))
 profest <- c(r= 0.32,K=11500,Binit=4250,sigma=0.05) # end of sequence
 for (i in 1:11) { 
   param <- log(c(rval[i],profest[2:4])) #recycle the profest values to
   parinit <- param    # improve the stability of nlm as the r value
   bestmodP <- nlm(f=negLLP,p=param,funk=simpspm,initpar=parinit, #changes
                   indat=abdat,logobs=log(abdat$cpue),notfixed=c(2:4))
   bestest <- exp(bestmodP$estimate)     
   result[i,] <- c(bestest,bestmodP$minimum)  # store each result
 }
 result   #Now you can plot -veLL againt r values for the profile
}
