% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updt_restricted.R
\name{updt_restricted}
\alias{updt_restricted}
\title{Restricted Neighborhood Replacement Update for MOEA/D}
\usage{
updt_restricted(update, X, Xt, Y, Yt, V, Vt, sel.indx, B, ...)
}
\arguments{
\item{update}{List containing the population update parameters. See
Section \code{Update Strategies} of the \code{\link[=moead]{moead()}} documentation for
details. \code{update} must contain a field \code{update$nr}, a positive integer that
determines the maximum number of copies of each candidate solution.}

\item{X}{Matrix of candidate solutions}

\item{Xt}{Matrix of incumbent solutions}

\item{Y}{Matrix of objective function values of \code{X}}

\item{Yt}{Matrix of objective function values of \code{Xt}}

\item{V}{List object containing information about the constraint violations
of the candidate solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{Vt}{List object containing information about the constraint violations
of the incumbent solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{sel.indx}{matrix of selection indices, generated by
\code{\link[=order_neighborhood]{order_neighborhood()}}}

\item{B}{Neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
List object containing the update population matrix (\code{X}),
and its corresponding matrix of objective function values (\code{Y}) and
constraint value list (\code{V}).
}
\description{
Population update using the restricted neighborhood replacement
method for the MOEADr package.
}
\details{
The restricted neighborhood replacement method behaves like the "standard"
replacement method, except that each individual can only be selected up to
\code{nr} times. After this limit has been reached, the next best individual in
the same neighborhood is selected.

This update routine is intended to be used internally by the main \code{\link[=moead]{moead()}}
function, and should not be called directly by the user.
}
