% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinate_conversion.R
\name{mt_bbox}
\alias{mt_bbox}
\title{Converts lower-left sinusoidal coordinates to lat-lon sf bounding box}
\usage{
mt_bbox(xllcorner, yllcorner, cellsize, nrows, ncols, transform = TRUE)
}
\arguments{
\item{xllcorner}{lower left x coordinate as provided by
\code{\link[MODISTools]{mt_subset}}}

\item{yllcorner}{lower left y coordinate as provided by
\code{\link[MODISTools]{mt_subset}}}

\item{cellsize}{cell size provided by \code{\link[MODISTools]{mt_subset}}}

\item{nrows}{cell size provided by \code{\link[MODISTools]{mt_subset}}}

\item{ncols}{cell size provided by \code{\link[MODISTools]{mt_subset}}}

\item{transform}{transform the bounding box from sin to lat long coordinates,
\code{TRUE} or \code{FALSE} (default = \code{TRUE})}
}
\description{
Converts lower-left sinusoidal coordinates to lat-lon sf bounding box
}
\examples{

\donttest{
# Download some test data
subset <- mt_subset(product = "MOD11A2",
                        lat = 40,
                        lon = -110,
                        band = "LST_Day_1km",
                        start = "2004-01-01",
                        end = "2004-03-31",
                        progress = FALSE)

# convert sinusoidal to lat / lon
lat_lon <- sin_to_ll(subset$xllcorner, subset$yllcorner)

# bind with the original dataframe
subset <- cbind(subset, lat_lon)

# convert to bounding box
bb <- apply(subset, 1, function(x){
  mt_bbox(xllcorner = x['xllcorner'],
          yllcorner = x['yllcorner'],
          cellsize = x['cellsize'],
          nrows = x['nrows'],
          ncols = x['ncols'])
})

head(bb)
}
}
\seealso{
\code{\link[MODISTools]{sin_to_ll}},
\code{\link[MODISTools]{mt_subset}}
}
