% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHdf.R
\docType{methods}
\name{getHdf}
\alias{getHdf}
\alias{getHdf,character-method}
\alias{getHdf,missing-method}
\title{Create or Update Local Subset of Online MODIS Data Pool}
\usage{
\S4method{getHdf}{character}(product, HdfName, begin = NULL, end = NULL,
  tileH = NULL, tileV = NULL, extent = NULL, collection = NULL,
  wait = 0.5, checkIntegrity = TRUE, forceDownload = TRUE, ...)

\S4method{getHdf}{missing}(HdfName, wait = 0.5, checkIntegrity = TRUE, ...)
}
\arguments{
\item{product}{\code{character}. MODIS grid product to be downloaded, see 
\code{\link{getProduct}}. Use dot notation to address Terra and Aqua products 
(e.g. \code{M.D13Q1}).}

\item{HdfName}{\code{character} vector or \code{list}. Full HDF file name(s) 
to download a small set of files. If specified, other file-related parameters 
(i.e., \code{begin}, \code{end}, \code{collection}, etc.) are ignored.}

\item{begin}{\code{character}. Begin date of MODIS time series, see 
\code{\link{transDate}} for formatting.}

\item{end}{\code{character}. End date, compatible with future dates for 
continuous updates via scheduled jobs.}

\item{tileH}{\code{numeric} or \code{character}. Horizontal tile number(s), 
see \code{\link{getTile}}.}

\item{tileV}{\code{numeric} or \code{character}. Vertical tile number(s), 
see \code{tileH}.}

\item{extent}{See Details in \code{\link{getTile}}.}

\item{collection}{\code{character} or \code{integer}. Desired MODIS product 
collection, see MODIS pages or \code{\link{getCollection}} for more information.}

\item{wait}{\code{numeric}. Inserts a break (in seconds) after every internal 
call to \code{\link{download.file}} or \code{\link{getURL}}, which reduces 
the chance of FTP connection errors that frequently occur after many requests.}

\item{checkIntegrity}{\code{logical}. If \code{TRUE} (default), the size of 
each downloaded file is checked. In case of inconsistencies, the function 
tries to re-download broken files.}

\item{forceDownload}{\code{logical}. If \code{TRUE} (default), try to 
download data irrespective of whether online information could be retrieved 
via \code{MODIS:::getStruc} or not.}

\item{...}{Arguments found in \code{\link{MODISoptions}}, sections 'STORAGE' 
and 'DOWNLOAD'.}
}
\value{
An invisible vector of downloaded data and paths.
}
\description{
Create or update a local user-defined subset of the global MODIS grid data 
archive. Based on user-specific parameters the function checks in the local 
archive for available data and downloads missing data from the online MODIS 
data pool. When run in a schedule job, the function manage the continuous 
update of the local MODIS data archive.
}
\examples{
\dontrun{
# One or more specific file (no regular erpression allowed here)
a <- getHdf(HdfName = c("MYD11A1.A2009001.h18v04.006.2015363221538.hdf", 
                        "MYD11A1.A2009009.h18v04.006.2015364055036.hdf", 
                        "MYD11A1.A2009017.h18v04.006.2015364115403.hdf"))
a

# Get all MODIS Terra and Aqua M*D11A1 data from 1 December 2016 up to today
# (can be ran in a sceduled job for daily archive update)
b1 <- getHdf(product = "M.D11A1", begin = "2016.12.01", 
             tileH = 18:19, tileV = 4) 
b1               

# Same tiles with a 'list' extent
Austria <- list(xmax = 17.47, xmin = 9.2, ymin = 46.12, ymax = 49.3)
b2 <- getHdf(product = "M.D11A1", begin = "2016336", extent = Austria)
b2

# Using country boarders from 'mapdata' package
c <- getHdf(product = "M.D11A1", begin = "2016306", end = "2016335",
            extent = "Luxembourg")
c             
       
# Interactive selection of spatial extent, see getTile()
d <- getHdf(product = "M.D11A1", begin = "2016306", end = "2016307")
d
}

}
\author{
Matteo Mattiuzzi
}
\references{
MODIS data is obtained through the online Data Pool at the NASA Land 
Processes Distributed Active Archive Center (LP DAAC), USGS/Earth Resources 
Observation and Science (EROS) Center, Sioux Falls, South Dakota 
\url{https://lpdaac.usgs.gov/get_data}.
}

