% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNormTest.R
\name{meanTest.single}
\alias{meanTest.single}
\title{Single Mean Vector Hypothesis Testing}
\usage{
meanTest.single(data, mu0, Sigma0 = FALSE, alpha = 0.05, verbose = TRUE)
}
\arguments{
\item{data}{The data matrix which is a matrix or data frame.}

\item{mu0}{The mean vector when the null hypothesis is true.}

\item{Sigma0}{The population covariance matrix. Default is FALSE which means the covariance matrix is unknown.}

\item{alpha}{The significance level. Default is 0.05.}

\item{verbose}{A boolean value. Default is TRUE. If TRUE, the null hypothesis will be displayed. If FALSE, the test will be carried out silently.}
}
\value{
An object of class "testResult", which is a list with the following elements:
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMean}{The sample mean.}
\item{SampA}{The sample deviation.}
\item{Df}{The degree of freedom.}
}
\description{
Test whether the mean vector of a single multivariate normal population is equal to a certain value when the population covariance matrix is known or unknown. The null hypothesis is that "H0: mu = mu0".
}
\examples{
data(iris)
X <- iris[, 1:4]
mu0 <- c(5.8, 3.0, 4.3, 1.3)
# carry out the test
test1 <- meanTest.single(X, mu0)
test2 <- meanTest.single(X, mu0, Sigma0 = diag(1, 4))
test3 <- meanTest.single(X, mu0, verbose = FALSE)
# get the elements
test1$Stat
test1$SampMean
test1$SampA
test1$Df
}
\references{
Huixuan, Gao. Applied Multivariate Statistical Analysis. Peking University Press, 2005: pp.66-68.
}
\author{
Xifeng Zhang
}
