% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{global.MNB}
\alias{global.MNB}
\title{Global influence}
\usage{
global.MNB(formula, star, dataSet, plot = TRUE)
}
\arguments{
\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones).}

\item{star}{Initial values for the parameters to be optimized over.}

\item{dataSet}{data}

\item{plot}{TRUE or FALSE. Indicates if a graph should be plotted.}
}
\value{
L and graphics
}
\description{
It performers influence analysis by a global influence to evaluate the impact on the parameter
estimates when we remove a particular observation.
}
\details{
The function returns a list (L) with the generalized Cook distance, Likelihood displacement and
index plot.
}
\examples{

\donttest{

data(seizures)
head(seizures)

star <-list(phi=1, beta0=1, beta1=1, beta2=1, beta3=1)
global.MNB(formula=Y ~ trt + period +
trt:period + offset(log(weeks)),star=star,dataSet=seizures,plot=FALSE)

}

}
\references{
\itemize{
\item Fabio, L. C, Villegas, C. L., Carrasco, J. M. F. and de Castro, M. (2020). Diagnostic tools for a multivariate
negative binomial model for fitting correlated data with overdispersion. Submitted.
}
}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
