% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMeM_Henderson3.R
\name{MMeM_henderson3}
\alias{MMeM_henderson3}
\title{Multivariate Henderson3 method}
\usage{
MMeM_henderson3(fml, data, factor_X)
}
\arguments{
\item{fml}{two-sided linear formula object describing both the fixed-effects and random-effects  parts  of  the  model,
 with  the  response  on  the  left  of  a ~ operator. For univariate response, put variable name directly; for multivariate responses
 combine variables using concatenate operator, for example, for bivariate responses, c(var1, var2).  The predictor terms are separated  by + operators,  on  the  right.   Random-effects  terms  are
distinguished by vertical bars '|' separating expressions for design matrices from grouping factors.}

\item{data}{data frame containing the variables named in formula.}

\item{factor_X}{(logical) indicating whether predictor is a factor or continuous. By default is TRUE}
}
\value{
The function returns a list with the following objects:
\itemize{
\item \code{T.estimates} is the estimated variance covariance components (T.estimates) of the variance covariance matrix of the block random effects with corresponding sampling variances (T.variance)
\item \code{E.estimates} is the estimated variance covariance components (E.estimates) of the variance covariance matrix of the residuals with corresponding sampling variances (E.variance)
}
}
\description{
Multivariate Henderson3 method
}
\examples{
data(simdata)
results_henderson <- MMeM_henderson3(fml = c(V1,V2) ~ X_vec + (1|Z_vec),
data = simdata, factor_X = TRUE)

}
\references{
Wesolowska Janczarek, M. T. "Estimation of covariance matrices in unbalanced random and mixed multivariate models." Biometrical journal 26.6 (1984): 665,674.
}
