% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmvbvs}
\alias{mmvbvs}
\title{Main function for variable selection}
\usage{
mmvbvs(X, Y, initial_chain, Phi, marcor, niter = 1000L, bgiter = 500L,
  hiter = 50L, burnin = 100000L, Vbeta = 1L, smallchange = 1e-04,
  verbose = TRUE)
}
\arguments{
\item{X}{covariate with length N, sample size}

\item{Y}{multivariate normal response variable N by P}

\item{initial_chain}{list of starting points for beta, gamma, sigma, and sigmabeta. beta is length P for the coefficients, gamma is length P inclusion vector where each element is 0 or 1. sigma should be P x P covariance matrix, and sigmabeta should be the expected variance of the betas.}

\item{Phi}{prior for the covariance matrix. We suggest identity matrix if there is no appropriate prior information}

\item{marcor}{length P vector of correlation between X and each variable of Y}

\item{niter}{total number of iteration for MCMC}

\item{bgiter}{number of MH iterations within one iteration of MCMC to fit Beta and Gamma}

\item{hiter}{number of first iterations to ignore}

\item{burnin}{number of MH iterations for h, proportion of variance explained}

\item{Vbeta}{variance of beta}

\item{smallchange}{perturbation size for MH algorithm}

\item{verbose}{if set TRUE, print gamma for each iteration}
}
\value{
list of posterior beta, gamma, and covariance matrix sigma
}
\description{
Main function for variable selection
}
\examples{
beta = c(rep(0.5, 3), rep(0,3))
n = 200; T = length(beta); nu = T+5
Sigma = matrix(0.8, T, T); diag(Sigma) = 1
X = as.numeric(scale(rnorm(n)))
 error = MASS::mvrnorm(n, rep(0,T), Sigma)
 gamma = c(rep(1,3), rep(0,3))
 Y = X \%*\% t(beta) + error; Y = scale(Y)
 Phi = matrix(0.5, T, T); diag(Phi) = 1
 initial_chain = list(beta = rep(0,T),
                        gamma = rep(0,T),
                        Sigma = Phi,
                        sigmabeta = 1)
     result = mmvbvs(X = X,
                     Y = Y,
                     initial_chain = initial_chain,
                     Phi = Phi,
                     marcor = colMeans(X*Y, na.rm=TRUE),
                     niter=10,
                     verbose = FALSE)
}
