\name{MLE of (hyper-)spherical distributions}
\alias{hspher.mle}
\title{
MLE of (hyper-)spherical distributions
}

\description{
MLE of (hyper-)spherical distributions.
}

\usage{
hspher.mle(x, distr = "vmf", ina, full = FALSE, ell = FALSE, tol = 1e-07)
}

\arguments{
\item{x}{
A matrix with directional data, i.e. unit vectors.
}
\item{distr}{
The distribution to fit. Spherical distributions: "iag" stands for the independent angular Gaussian distribution, "purka" is the Purkayastha distribution, and "sipc" is the spherical isotropic projected Cauchy. These are rotationally symmetric distributions. The "wood" is the Wood distribution, a bimodal distribution. The next three are elliptically symmetric distributions. The "kent" is the Kent distribution, "esag" is the elliptically symmetric angular Gaussian and the "sespc" is the spherical elliptically symmetric projected Cauchy distribution.

Spherical and hyper-spherical distributions: "vmf" stands for the von Mises-Fisher distribution, "multivmf" is for the vMF with multiple groups, "acg" is the angular central Gaussian and  and the "pkbd" is the Poisson kernel based distribution. The "spcauchy" and "spcauchy2" are the spherical Cauchy (2 different methods of estimation).
}
\item{ina}{
A numerical vector with discrete numbers starting from 1, i.e. 1, 2, 3, 4,... or a factor variable. Each number denotes a sample or group.
If you supply a continuous valued vector the function will obviously provide wrong results.
}
\item{full}{
If you want some extra information, the inverse of the covariance matrix, set this equal to TRUE. Otherwise leave it FALSE.
}
\item{ell}{
This is for the multivmf.mle only. Do you want the log-likelihood returned? The default value is TRUE.
}
\item{tol}{
The tolerance value at which to terminate the iterations.
}
}

\details{
For the von Mises-Fisher, the normalised mean is the mean direction. For the concentration parameter, a Newton-Raphson is implemented. For the angular central Gaussian distribution there is a constraint on the estimated covariance matrix; its trace is equal to the number of variables. An iterative algorithm takes place and convergence is guaranteed. Newton-Raphson for the projected normal distribution, on the sphere, is implemented as well.

The "vmf" estimates the mean direction and concentration of a fitted von Mises-Fisher distribution.
The von Mises-Fisher distribution for groups of data is also implemented. The "acg"" fits the angular central Gaussian distribution. There is a constraint on the estimated covariance matrix; its trace is equal to the number of variables. An iterative algorithm takes place and convergence is guaranteed. The "iag" implements MLE of the spherical projected normal distribution, for spherical data only. The "spcauchy" is faster than the "spcacuhy2" because it employs the Newton-Raphson algortihm. Both functions estimate the parameters of the spherical Cauchy distribution, for any dimension. Despite the name sounds confusing, it is implemented for arbitrary dimensions, not only the sphere. The function employs a combination of the fixed points iteration algorithm and the Brent algorithm. The "pkbd" estimates the parameters of the Poisson kernel based distribution (PKBD), for any dimension. The "sipc" implements MLE of the spherical independent projected Cauchy distribution, for spherical data only.
}

\value{
For the von Mises-Fisher a list including:
\item{loglik}{
The maximum log-likelihood value.
}
\item{mu}{
The mean direction.
}
\item{kappa}{
The concentration parameter.
}
For the multi von Mises-Fisher a list including:
\item{loglik}{
A vector with the maximum log-likelihood values if ell is set to TRUE. Otherwise NULL is returned.
}
\item{mi}{
A matrix with the group mean directions.
}
\item{ki}{
A vector with the group concentration parameters.
}
For the angular central Gaussian a list including:
\item{iter}{
The number if iterations required by the algorithm to converge to the solution.
}
\item{cova}{
The estimated covariance matrix.
}
For the spherical projected normal a list including:
\item{iters}{
The number of iteration required by the Newton-Raphson.
}
\item{mesi}{
A matrix with two rows. The first row is the mean direction and the second is the mean vector.
The first comes from the second by normalising to have unit length.
}
\item{param}{
A vector with the elements, the norm of mean vector, the log-likelihood and the log-likelihood of the spherical uniform distribution.
The third value helps in case you want to do a log-likleihood ratio test for uniformity.
}
For the spherical Cauchy and the PKBD a list including:
\item{mesos}{
The mean in \eqn{R^{d+1}}. See Tsagris and Alenazy (2023) for a re-parametrization that
applies in the spherical Cauchy also.
}
\item{mu}{
The mean direction.
}
\item{gamma}{
The norm of the mean in \eqn{R^{d+1}}. See Tsagris and Alenazy (2023) for a re-parametrization that
applies in the spherical Cauchy also.
}
\item{rho}{
The concetration parameter, this takes values in [0, 1).
}
\item{loglik}{
The log-likelihood value.
}
For the SIPC a list including:
\item{mu}{
The mean direction.
}
\item{loglik}{
The log-likelihood value.
}
For the Kent a list including:
\item{runtime}{
The run time of the procedure.
}
\item{G}{
A 3 x 3 matrix whose first column is the mean direction. The second and third columns are the major and minor axes respectively.
}
\item{param}{
A vector with the concentration \eqn{\kappa} and ovalness \eqn{\beta} parameters and the angle \eqn{\psi} used to rotate \bold{H}
and hence estimate \bold{G} as in Kent (1982).
}
\item{logcon}{
The logarithm of the normalising constant, using the third type approximation (Kume and Wood, 2005).
}
\item{loglik}{
The value of the log-likelihood.
}
For the ESAG a list including:
\item{mu}{
The mean vector in \eqn{R^3}.
}
\item{gam}{
The two \eqn{\gamma} parameters.
}
\item{loglik}{
The log-likelihood value.
}
\item{vinv}{
The inverse of the covariance matrix. It is returned if the argument "full" is TRUE.
}
\item{rho}{
The \eqn{rho} parameter (smallest eigenvalue of the covariance matrix). It is returned if the argument "full" is TRUE.
}
\item{psi}{
The angle of rotation \eqn{\psi} set this equal to TRUE. It is returned if the argument "full" is TRUE.
}
\item{iag.loglik}{
The log-likelihood value of the isotropic angular Gaussian distribution. That is, the projected
normal distribution which is rotationally symmetric.
}
For the SESPC a list including:
\item{mu}{
The mean vector in \eqn{R^3}.
}
\item{theta}{
The two \eqn{\theta} parameters.
}
\item{loglik}{
The log-likelihood value.
}
\item{vinv}{
The inverse of the covariance matrix. It is returned if the argument "full" is TRUE.
}
\item{lambda}{
The \eqn{\lambda_2} parameter (smallest eigenvalue of the covariance matrix). It is returned if the argument "full" is TRUE.
}
\item{psi}{
The angle of rotation \eqn{\psi} set this equal to TRUE. It is returned if the argument "full" is TRUE.
}
\item{sipc.loglik}{
The log-likelihood value of the isotropic prohected Cuchy distribution, which is rotationally symmetric.
}
For the Wood distribution a list including:
\item{info}{
A 5 x 3 matrix containing the 5 parameters, \eqn{\gamma}, \eqn{\delta}, \eqn{\alpha}, \eqn{\beta} and \eqn{\kappa} along with their corresponding 95\% confidence intervals all expressed in degrees.
}
\item{modes}{
The two axis of the modes of the distribution expressed in degrees.
}
\item{unitvectors}{
A 3 x 3 matrix with the 3 unit vectors associated with the \eqn{\gamma} and \eqn{\delta} parameters.
}
\item{loglik}{
The value of the log-likelihood.
}
For the Purkayastha a list including:
\item{theta}{
The median direction.
}
\item{alpha}{
The concentration parameter.
}
\item{loglik}{
The log-likelihood.
}
\item{alpha.sd}{
The standard error of the concentration parameter.
}
}

\references{
Mardia, K. V. and Jupp, P. E. (2000). Directional statistics. Chicester: John Wiley & Sons.

Sra, S. (2012). A short note on parameter approximation for von Mises-Fisher distributions: and a fast implementation of Is(x).
Computational Statistics, 27(1): 177--190.

Tyler D. E. (1987). Statistical analysis for the angular central Gaussian distribution on the sphere.
Biometrika 74(3): 579-589.

Paine P.J., Preston S.P., Tsagris M and Wood A.T.A. (2018). An Elliptically Symmetric Angular Gaussian Distribution.
Statistics and Computing, 28, 689--697.

Tsagris M. and Alzeley O. (2023). Circular and spherical projected Cauchy distributions:
A Novel Framework for Circular and Directional Data Modeling.
https://arxiv.org/pdf/2302.02468.pdf

Kato S. and McCullagh P. (2020). Some properties of a Cauchy family on the sphere derived from the
Mobius transformations. Bernoulli, 26(4): 3224--3248.
https://arxiv.org/pdf/1510.07679.pdf

Golzy M. and Markatou M. (2020). Poisson kernel-based clustering on the sphere:
convergence properties, identifiability, and a method of sampling.
Journal of Computational and Graphical Statistics, 29(4): 758--770.

Sablica L., Hornik K. and Leydold J. (2023). Efficient sampling from the PKBD distribution.
Electronic Journal of Statistics, 17(2): 2180--2209.

Wood A.T.A. (1982). A bimodal distribution on the sphere.
Journal of the Royal Statistical Society, Series C, 31(1): 52--58.

Purkayastha S. (1991).  A Rotationally Symmetric Directional Distribution: Obtained through Maximum
Likelihood Characterization. The Indian Journal of Statistics, Series A, 53(1): 70--83

Cabrera J. and Watson G. S. (1990). On a spherical median related distribution.
Communications in Statistics-Theory and Methods, 19(6): 1973--1986.
}

\author{
Michail Tsagris and Sofia Piperaki.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr} and Sofia Piperaki  \email{sofiapip23@gmail.com}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{circ.mle}
}
}

\examples{
m <- c(0, 0, 0, 0)
s <- cov(iris[, 1:4])
x <- matrix( rnorm(100 * 3), ncol = 3 )
x <- x / sqrt( rowSums(x^2) )
hspher.mle(x, distr = "iag")
}

