\name{combine.EMC}
\alias{combine.EMC}

\title{ Calculates Global and Marginal Summaries }

\description{
  This function calculates the global and marginal posterior
  probabilities and Bayes Factors that give the evidence of there being an
  association in the overall set of SNPs of interest, the individual genes
  of interest and the individual SNPs of interest.
}

\usage{
combine.EMC(emc.list) }

\arguments{
  \item{emc.list}{A list of output structures from \code{\link{Gene.EMC}} }

}
\details{
  This function consolidates multiple outputs from \code{\link{Gene.EMC}}
  into a single structure.
}

\value{
  A structure of the form generated by \code{\link{Gene.EMC}} combining
  the results in emc.list.
}

\author{ Gary Lipton <gl37@stat.duke.edu> }

\examples{
data(emc.out.1)
data(emc.out.2)
combo.out <- combine.EMC(list(emc.out.1, emc.out.2))
}


\keyword{ methods }
