% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data.R
\name{standardise_mic}
\alias{standardise_mic}
\title{Standardise MIC to control strain
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
\usage{
standardise_mic(
  test_measurement,
  qc_measurement,
  strain,
  ab,
  prefer_upper = FALSE,
  ignore_na = TRUE,
  guideline = "EUCAST",
  year = "2023",
  force = TRUE
)
}
\arguments{
\item{test_measurement}{Measured MIC to standardise}

\item{qc_measurement}{Measured QC MIC to standardise to}

\item{strain}{control strain identifier (usually ATCC)}

\item{ab}{antibiotic name (will be coerced to AMR::as.ab)}

\item{prefer_upper}{Where the target MIC is a range, prefer the upper value
in the range}

\item{ignore_na}{Ignore NA (returns AMR::NA_mic_)}

\item{guideline}{Guideline to use (EUCAST or CLSI)}

\item{year}{Guideline year (version)}

\item{force}{Force into MIC-compatible format after standardisation}
}
\value{
AMR::mic vector
}
\description{
MIC experiments are generally quality-controlled by including a control strain
with a known MIC. The MIC result for the control strain should be a particular
target MIC, or at least within an acceptable range. This function standardises
a measured MIC to the target MIC given: 1) a control strain (usually identified
as an ATCC or NCTC number), 2) an antibiotic name, and 3) a guideline (EUCAST
or CLSI). The definition of standardisation in this context is to adjust the
measured MIC based on the QC MIC. This is based on the following principles
and assumption:
\enumerate{
\item A measured MIC is composed of two components: the true MIC and a
measurement error. The measurement error is considered to be inevitable when
measuring MICs, and is likely to be further composed of variability in
laboratory conditions and operator interpretation.
\item It is assumed that the MIC of the control strain in the experiment has
also been affected by this error.
}

The standardisation applied by this function uses the measured QC strain
MIC as a reference point, and scales the rest of the MICs to this reference.
In general, this means that the MICs are doubled or halved, depending on the
result of the QC MIC. A worked example is provided below and illustrates
the transformation that this function applies.

There is no current evidence base for this approach, therefore, this
function is considered experimental and should be used with caution.
}
\examples{
# Ref strain QC MIC for GEN is 0.5
standardise_mic(
  test_measurement = c(AMR::as.mic(">8.0"),  # QC = 1, censored MIC remains censored
                       AMR::as.mic(4.0),  # QC = 0.5 which is on target, so stays same
                       AMR::as.mic(2),  # QC = 1, so scaled down to 1
                       AMR::as.mic(2)),  # QC = 0.25, so scaled up to 8
  qc_measurement = c(AMR::as.mic(1),
                     AMR::as.mic(0.5),
                     AMR::as.mic(1),
                     AMR::as.mic(0.25)),
  strain = 25922,
  ab = AMR::as.ab("GEN"))
}
