% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.MGLM.R
\docType{methods}
\name{coef}
\alias{coef}
\alias{coef,MGLMfit-method}
\alias{coef,MGLMreg-method}
\alias{coef,MGLMsparsereg-method}
\alias{coef,MGLMtune-method}
\title{Extract Model Coefficients}
\usage{
\S4method{coef}{MGLMfit}(object)

\S4method{coef}{MGLMreg}(object)

\S4method{coef}{MGLMsparsereg}(object)

\S4method{coef}{MGLMtune}(object)
}
\arguments{
\item{object}{an object for which the extraction of model coefficients is meaningful. 
One of the following classes \code{"MGLMfit"}, \code{"MGLMreg"},
\code{"MGLMsparsereg"}, \code{"MGLMtune"}}
}
\value{
Coefficients extracted from the model object \code{object}.

For the class \code{"MGLMtune"}, the function returns model coefficients 
based on the optimal tuning parameter.
}
\description{
\code{coef} extracts estimated model coefficients of class. \code{coefficients} is an \emph{alias} for it.
}
\details{
Method coef.
}
\examples{
library("MGLM")
data("rnaseq")
data <- rnaseq[, 1:6]
mnreg <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ log(totalReads) + 
treatment + age + gender, data = rnaseq, dist = "MN")
coef(mnreg)
}
