% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.MGLMsparsereg.R
\docType{methods}
\name{maxlambda}
\alias{maxlambda}
\alias{maxlambda,MGLMsparsereg-method}
\title{Extract maximum lambda}
\usage{
\S4method{maxlambda}{MGLMsparsereg}(object)
}
\arguments{
\item{object}{an object of class \code{MGLMsparsereg} from which
maximum lambda value can be extracted.}
}
\value{
Returns a maximum lambda value of \code{object}.
}
\description{
\code{maxlambda} extracts the maximum tuning parameter that ensures 
the estimated regression coefficients are not all zero for the object of class \code{MGLMsparsereg}.
}
\examples{
library("MGLM")
dist <- "DM"
n <- 100
p <- 10
d <- 5
set.seed(118)
m <- rbinom(n, 200, 0.8)
X <- matrix(rnorm(n * p), n, p)
alpha <- matrix(0, p, d)
alpha[c(1, 3, 5), ] <- 1
Alpha <- exp(X \%*\% alpha)
Y <- rdirmn(size = m, alpha = Alpha)
pen <- "group"
ngridpt <- 30
spmodelfit <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist, 
                            lambda = Inf, penalty = pen)
maxlambda <- maxlambda(spmodelfit)
}
