% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.MGLMsparsereg.R
\docType{methods}
\name{dof}
\alias{dof}
\alias{dof,MGLMsparsereg-method}
\title{Extract degrees of freedom}
\usage{
\S4method{dof}{MGLMsparsereg}(object)
}
\arguments{
\item{object}{an object of class \code{MGLMsparsereg}}
}
\value{
Returns degrees of freedom of \code{object}.
}
\description{
\code{dof} extracts the degrees of freedom of the estimated parameter 
from the object of class \code{MGLMsparsereg}.
}
\examples{
library("MGLM")
dist <- "DM"
n <- 100
p <- 10
d <- 5
set.seed(118)
m <- rbinom(n, 200, 0.8)
X <- matrix(rnorm(n * p), n, p)
alpha <- matrix(0, p, d)
alpha[c(1, 3, 5), ] <- 1
Alpha <- exp(X \%*\% alpha)
Y <- rdirmn(size = m, alpha = Alpha)
pen <- "group"
ngridpt <- 30
spmodelfit <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist, 
                            lambda = Inf, penalty = pen)
df <- dof(spmodelfit)
}
