% Generated by roxygen2 (4.0.2): do not edit by hand
\name{MGL}
\alias{MGL}
\title{Module network inference}
\usage{
MGL(data, L, lambda, printoutput = 0, maxiter = 100, threshold = 0.01)
}
\arguments{
\item{data}{An nxp matrix which contains n samples from p variables, where typically p>>n}

\item{L}{An nxk matrix which contains the initial latent variable values, a column for each module}

\item{lambda}{A penalty parameter controlling the sparsity of the conditional dependency network among the modules}

\item{printoutput}{1 if the user wants the output from each iteration to be displayed, 0 for silent run}

\item{maxiter}{Maximum number of iterations to be performed}

\item{threshold}{Threshold for convergence}
}
\value{
\item{L}{An nxk matrix which contains the final latent variable values, a column for each module}

\item{theta}{A kxk symmetric positive-semidefinite matrix respresenting the conditional dependency network among the modules}

\item{Z}{A p-vector containing values between 1 to k, representing the assignment of the p variables to k modules}
}
\description{
Takes a high-dimensional data matrix, initial values of the module latent variables, and a penalty parameter,
and returns the final assignment of the data points to the modules, the values of the module latent variables,
and the conditional dependency network among the module latent variables.
}
\examples{
\dontrun{
library(MGL)
n = 20 #sample size
p = 100 #variable size
k = 5 #module size
lambda = .01 #penalty parameter to induce sparsity
data = matrix(rnorm(n*p), ncol=p)
# to start with initial random module latent variables
L = matrix(rnorm(n*k), ncol=k)
MGL(data, L, lambda)
# to start with k-means cluster centroids as module latent variables
L = t(kmeans(t(data), k)$centers)
MGL(data, L, lambda)
}
}

