% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCSIS.R
\name{PCSIS}
\alias{PCSIS}
\title{Model-Free Feature Screening Based on the Projection Correlation}
\usage{
PCSIS(X, Y, nsis = (dim(X)[1])/log(dim(X)[1]))
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by PCSIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A model-free screening method is based on the projection correlation
which measures the dependence between two random vectors.
This projection correlation based method does not require specifying a
regression model, and applies to data in the presence of heavy tails
and multivariate responses. It enjoys both sure screening and
rank consistency properties under weak assumptions.
}
\examples{

have_numpy=reticulate::py_module_available("numpy")
if (have_numpy){
req_py()
library(MFSIS)
n=100;
p=200;
pho=0.5;
data=gendata1(n,p,pho)
data=cbind(data[[1]],data[[2]])
colnames(data)[1:ncol(data)]=c(paste0("X",1:(ncol(data)-1)),"Y")
data=as.matrix(data)
X=data[,1:(ncol(data)-1)];
Y=data[,ncol(data)];
A=PCSIS(X,Y,n/log(n));A
}else{
   print('You should have the Python testing environment!')
}

}
\references{
Zhu, L., K. Xu, R. Li, and W. Zhong (2017). Projection correlation between two random vectors. Biometrika 104(4), 829–843.

Liu, W., Y. Ke, J. Liu, and R. Li (2020). Model-free feature screening and FDR control with knockoff features. Journal of the American Statistical Association, 1–16.
}
\author{
Xuewei Cheng \email{xwcheng@csu.edu.cn}
}
