% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.nnfit.loci}
\alias{calc.nnfit.loci}
\title{Calculates the nearest neighbour fit for an individual marker.}
\usage{
calc.nnfit.loci(loci, distmap, lodmap, estmap)
}
\arguments{
\item{loci}{Scalar indicating the estimated rank position of the marker.}

\item{distmap}{Symmetric matrix of pairwise inter-marker distances with columns
and rows corresponding to the estimated map order.}

\item{lodmap}{Symmetric matrix of pairwise lod scores with columns and rows
corresponding to the estimated map order.}

\item{estmap}{Vector of estimated marker positions.}
}
\value{
Scalar corresponding to the difference between the observed and 
estimated intermarker differences.
}
\description{
Calculates the nearest neighbour fit for an individual marker.
}
\details{
The nearest neighbour fit for a marker is the sum of the difference between 
the observed and estimated distances between the marker and its nearest 
informative neighbour. A neighbour is informative if the LOD score for the 
inter-marker distance is non zero. This function finds the nearest markers 
with a non-zero LOD score (this may be one or two markers). Calculates the 
estimated distances between these markers and the marker of interest and 
returns the sum of the absolute values of the difference between the observed 
and estimated distances.
}
