% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomHMDP.R
\name{randomHMDP}
\alias{randomHMDP}
\title{Generate a "random" HMDP stored in a set of binary files.}
\usage{
randomHMDP(
  prefix = "",
  levels = 3,
  timeHorizon = c(Inf, 3, 4),
  states = c(2, 4, 5),
  actions = c(1, 2),
  childProcessPr = 0.5,
  externalProcessPr = 0,
  rewards = c(0, 100),
  durations = c(1, 10),
  rewardName = "Reward",
  durationName = "Duration"
)
}
\arguments{
\item{prefix}{A character string with the prefix added to the file(s).}

\item{levels}{Maximum number of levels. Set \code{childProcessPr = 1} if want exact this number of levels.}

\item{timeHorizon}{The time horizon for each level (vector). For the founder the time-horizon can be Inf.}

\item{states}{Number of states at each stage at a given level (vector of length levels)}

\item{actions}{Min and max number of actions at a state.}

\item{childProcessPr}{Probability of creating a child process when define action.}

\item{externalProcessPr}{Probability of creating an external process given that we create a child process. Only works if levels>2 and and currently does not generate external processes which include external processes.}

\item{rewards}{Min and max reward used.}

\item{durations}{Min and max duration used.}

\item{rewardName}{Weight name used for reward.}

\item{durationName}{Weight name used for duration.}
}
\value{
The file prefix (character).
}
\description{
Generate a "random" HMDP stored in a set of binary files.
}
