% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contour_Plot.R
\name{Contour_Plot}
\alias{Contour_Plot}
\title{Contour plot of the bivariate exponential distribution (BED) based on the Moran-Downton model}
\usage{
Contour_Plot(
  rho,
  Betax,
  Betay,
  Pr = c(5, 25, 75, 95),
  xlabel = "x",
  ylabel = "y",
  title = "BED",
  Rvalues = FALSE,
  n = 1000
)
}
\arguments{
\item{rho}{Correlation coefficient between marginal distributions of x and y.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{Pr}{A value or vector of values specifing the cumulative joint probability associated to the contour plot.
Default values 5\%, 25\%, 75\%, and 95\%.}

\item{xlabel}{Label of the x-axis.}

\item{ylabel}{Label of the y-axis.}

\item{title}{Title of the figure.}

\item{Rvalues}{True or False variable (Optional). If TRUE is specified, pairs (x,y) are plotted on the contour plot.
If FALSE is specifed, only the contours are plotted. Default FALSE.}

\item{n}{Numbers of pairs (x,y) to be plotted if Rvalues is specified as TRUE. Default value 1000.}
}
\value{
The Contour plot of the BED is provided.
}
\description{
This function builds the contour plot of the BED. The required inputs are the correlation coefficient, the
scale parameters of the marginal distributions, and the values of the cumulative joint probabilities associated
to the contours (Default values 5\%, 25\%, 75\%, and 95\%). This function also allows pair of values to be plotted on
the contour plot.
}
\examples{
\donttest{Contour_Plot(rho=0.5,Betax=1,Betay=1)}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
