% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{write.beta}
\alias{write.beta}
\title{Adds sections of JAGS code for an MBNMA model that correspond to beta
parameters}
\usage{
write.beta(model, timecourse, beta.1, beta.2 = NULL, beta.3 = NULL,
  beta.4 = NULL, UME, class.effect)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}

\item{timecourse}{A character object representing the time-course used in the MBNMA model}

\item{beta.1}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.2}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.3}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.4}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{UME}{Can take either \code{TRUE} or \code{FALSE} (for an unrelated mean effects
model on all or no time-course parameters respectively) or can be a vector
of parameter name strings to model as UME. For example: \code{c("beta.1", "beta.2")}.}

\item{class.effect}{A list of named strings that determines which time-course
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). For example: \code{list("beta.2"="common", "beta.3"="random")}.}
}
\value{
A character object of JAGS MBNMA model code that includes beta
parameter components of the model
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to beta
parameters
}
