% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.MBWCov.R
\name{print.MBWCov}
\alias{print.MBWCov}
\title{Main Results for Multiblock Weighted Covariate analysis (MB-WCov)}
\usage{
\method{print}{MBWCov}(x, ...)
}
\arguments{
\item{x}{An object of class \code{MBWCov}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns a list of the following elements:\cr

components  :  Numeric vector of length two that gives the number of global components of the analysis and the number of global components to print.

optimalcrit  :  Numeric vector that gives the optimal value of the criterion to be maximized for each dimension.

cumexplained   :  Four columns matrix of percentages of total inertia of the explanatory blocks, percentages of inertia of the response block
explained by the successive global components and their cumulative values.

explained.X  :  Matrix of percentages of inertia explained for each Xb block.

explained.Y  :  Matrix of percentages of inertia explained for each Y variable.

saliences  :  Matrix containing the specific weights of each explanatory block of variables on global components.

contrib  :  Matrix of contribution of each Xb block to the determination of global components.

T  :  Matrix of global components (scores of individuals).

C  :  Compromise matrix (unnormed global components).

U  :  Matrix of components associated with the response block of variables.

globalcor  :  Matrix of correlation coefficients between the original variables and the global components.

cor.g.b  :  Array that gives the correlation of the global components with their respective block components.

betaY  :  Array of regression coefficients.

\item{Block}{ : Results associated with each block of variables.
         \itemize{
               \item {T.b}{ : Array that contains the matrices of block components.}
               \item {blockcor}{ : List of matrices of correlation coefficients between the original variables of each block of variables and the block components.}
       }}
}
\description{
Print the main results for MB-WCov.
}
\examples{
data(ham)
X=ham$X
group=ham$group
Y=ham$Y
res.mbwcov <- MBWCov(X, Y, group)
print(res.mbwcov)

}
\seealso{
\code{\link{MBWCov}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
