% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ComDim.R
\name{print.ComDim}
\alias{print.ComDim}
\title{Main Results for Common Dimensions analysis (ComDim)}
\usage{
\method{print}{ComDim}(x, ...)
}
\arguments{
\item{x}{An object of class \code{ComDim}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns a list of the following elements:\cr

components  :  Numeric vector of length two that indicates the number of global components of the analysis and the number of global components to print.

optimalcrit  :  Numeric vector that gives the optimal value of the criterion to be maximized for each dimension.

cumexplained  :  Two columns matrix of percentages of total inertia of the blocks of variables explained by the successive global components and their cumulative values.

explained.X  :  Matrix of percentages of inertia explained for each Xb block.

saliences  :  Matrix containing the specific weights of different blocks of variables on global components.

contrib  :  Matrix of contribution of each Xb block to the determination of global components.

T  :  Matrix of global components (scores of individuals).

C  :  Compromise matrix (unnormed global components).

globalcor  :  Matrix of correlation coefficients between the original variables and the global components.

cor.g.b  :  Array that gives the correlation of the global components with their respective block components.

\item{Block}{ : Results associated with each block of variables.
         \itemize{
               \item {T.b}{ : Array that contains the matrices of block components.}
               \item {blockcor}{ : List of matrices of correlation coefficients between the original variables of each block and the block components.}
       }}
}
\description{
Print the main results for ComDim.
}
\examples{
data(ham)
X=ham$X
group=ham$group
res.comdim <- ComDim(X, group, plotgraph=FALSE)
print(res.comdim)

}
\seealso{
\code{\link{ComDim}}
}
\author{
Essomanda TCHANDAO MANGAMANA \email{tchanesso@yahoo.fr}, Véronique CARIOU, Evelyne VIGNEAU.
}
