% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM-function.R
\name{RM}
\alias{RM}
\title{Tests for Repeated Measures in Semi-Parametric Factorial Designs}
\usage{
RM(formula, data, subject, within, no.subf, iter = 10000, alpha = 0.05,
  resampling = "Perm", para = FALSE, CPU, seed,
  CI.method = "t-quantile", dec = 3)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. The within-subject factor(s)
must be the last factor(s) in the formula, e.g. 
\code{outcome ~ between1 * between2 * within1 * within2}.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. Data must be in long format and must not contain missing values.}

\item{subject}{The column name of the subjects in the data. NOTE: Subjects within 
different groups of between-subject factors must have individual labels, see Details for 
more explanation.}

\item{within}{Specifies the within-subject factor(s) in the formula. Either this
or \code{no.subf} must be specified.}

\item{no.subf}{The number of within-subject factors in the data. Must be specified if
\code{within} is omitted.}

\item{iter}{The number of iterations used for calculating the resampled 
statistic. The default option is 10,000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{resampling}{The resampling method to be used, one of "Perm" (randomly permute 
all observations), "paramBS" (parametric bootstrap approach) and "WildBS" 
(wild bootstrap approach with Rademacher weights). Except for the Wild Bootstrap,
all methods are applied to the WTS only.}

\item{para}{If parallel computing should be used. Default is FALSE.}

\item{CPU}{The number of cores used for parallel computing. If not specified, cores
are detected via \code{\link[parallel]{detectCores}}.}

\item{seed}{A random seed for the resampling procedure. If omitted, no 
reproducible seed is set.}

\item{CI.method}{The method for calculating the quantiles used for the confidence intervals, 
either "t-quantile" (the default) or "resampling" (the quantile of the resampled WTS).}

\item{dec}{Number of decimals the results should be rounded to. Default is 3.}
}
\value{
An \code{RM} object containing the following components:
\item{Descriptive}{Some descriptive statistics of the data for all factor
  level combinations. Displayed are the number of individuals per factor
  level combination, the mean and 100*(1-alpha)\% confidence
  intervals (based on t-quantiles).}
 \item{Covariance}{The estimated covariance matrix.} 
 \item{WTS}{The value of the WTS along with degrees of freedom of the central 
 chi-square distribution and 
  corresponding p-value.}
 \item{ATS}{The value of the ATS, degrees of freedom of the central F distribution 
 and the corresponding p-value.}
 \item{resampling}{p-values for the test statistics based on the chosen resampling
  approach.}
}
\description{
The RM() function calculates the Wald-type statistic (WTS), the ANOVA-type 
statistic (ATS) as well as resampling versions of these test statistics for 
semi-parametric repeated measures designs.
}
\details{
The RM() function provides the Wald-type
 statistic as well as the ANOVA-type statistic for repeated measures designs
 with metric data as described in Friedrich et al. (2017).
 These are even applicable for non-normal error terms and/or heteroscedastic
 variances. It is implemented for designs with an arbitrary number of 
 between-subject (whole-plot) and within-subject (sub-plot) factors and 
 allows for different sample sizes. In addition to the
 asymptotic p-values, it also provides p-values based on resampling
 approaches.
 NOTE: The number of within-subject factors or their labels need
  to be specified in the function call. If only one factor is 
  present, it is assumed that this is a within-subject factor
  (e.g. time).
 
 If subjects in different groups of the between-subject factor have the same id, they will 
 not be identified as different subjects and thus it is erroneously assumed that their 
 measurements belong to one subject. Example: Consider a study with one between-subject factor 
 "treatment" with levels verum and placebo and one within-subject factor "time" (4 measurements).
 If subjects in the placebo group are labeled 1-20 and subjects in the verum group have 
 the same labels, the program erroneously assumes 20 individuals with 8 measurements each instead of 
 40 individuals with 4 measurements each.
}
\examples{
data(o2cons)
\dontrun{
oxy <- RM(O2 ~ Group * Staphylococci * Time, data = o2cons, 
            subject = "Subject", no.subf = 2, iter = 1000,
            resampling = "Perm")
summary(oxy)
plot(oxy, factor = "Group") 
 
# For more details including the output of the examples also refer to the 
# package vignette.

# using the EEG data, consider additional within-subjects factors 'brain region' 
# and 'feature'
data(EEG)
EEG_model <- RM(resp ~ sex * diagnosis * feature * region, 
               data = EEG, subject = "id", within = c("feature", "region"),
               resampling = "WildBS",
               iter = 1000,  alpha = 0.01, seed = 987, dec = 2)
summary(EEG_model)
}

}
\references{
Friedrich, S., Konietschke, F., and Pauly, M. (2019). Resampling-Based Analysis
 of Multivariate Data and Repeated Measures Designs with the R Package MANOVA.RM.
 The R Journal, 11(2), 380-400.

 Friedrich, S., Brunner, E. and Pauly, M. (2017). Permuting longitudinal
 data in spite of the dependencies. Journal of Multivariate Analysis, 153, 255-265.

 Bathke, A., Friedrich, S., Konietschke, F., Pauly, M., Staffen, W., Strobl, N. and 
 Hoeller, Y. (2018). Testing Mean Differences among Groups: Multivariate and Repeated 
 Measures Analysis with Minimal Assumptions. Multivariate Behavioral Research, 53(3), 348-359,
 Doi: 10.1080/00273171.2018.1446320.
 
 Friedrich, S., Konietschke, F., Pauly, M. (2017). GFD - An 
 R-package for the Analysis of General Factorial Designs. 
 Journal of Statistical Software, 79(1), 1-18.
}
\seealso{
\code{\link[GFD]{GFD}}, \code{\link[nparLD]{nparLD}}, \code{\link{MANOVA}}
}
