## $Id: transformIntensity-methods.R 562 2011-05-26 08:56:09Z sgibb $
##
## Copyright 2011 Sebastian Gibb
## <mail@sebastiangibb.de>
##
## This file is part of MALDIquant for R and related languages.
##
## MALDIquant is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## MALDIquant is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with MALDIquant. If not, see <http://www.gnu.org/licenses/>

## AbstractMassSpectrumData 
setMethod(f="transformIntensity",
    signature=signature(object="AbstractMassSpectrumData"),
    definition=function(object, fun, na.rm=TRUE, ...) {

    fun <- match.fun(fun);

    object@intensity <- fun(object@intensity, ...);
    
    if (na.rm) {
        na <- is.na(object@intensity);
        object@intensity <- object@intensity[!na]; 
        object@mass <- object@mass[!na]; 
    }

    return(object);
});

