% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-summary.R
\name{summary.PLR}
\alias{summary.PLR}
\title{Summary for the Penalized Lorenz Regression}
\usage{
\method{summary}{PLR}(object, renormalize = TRUE, ...)
}
\arguments{
\item{object}{Output of a call to \code{\link{Lorenz.Reg}}, where \code{penalty!="none"}.}

\item{renormalize}{whether the coefficient vector should be re-normalized to match the representation where the first category of each categorical variable is omitted. Default value is TRUE}

\item{...}{Additional arguments.}
}
\value{
A summary displaying two tables: a summary of the model and the estimated coefficients.
}
\description{
\code{summary.PLR} provides a summary for an object of class \code{PLR}.
}
\examples{
data(Data.Incomes)
PLR <- Lorenz.Reg(Income ~ ., data = Data.Incomes, penalty = "SCAD",
                  sel.choice = c("BIC","CV"), h.grid = nrow(Data.Incomes)^(-1/5.5),
                  eps = 0.01, seed.CV = 123, nfolds = 5)
summary(PLR)

}
\seealso{
\code{\link{Lorenz.Reg}}
}
