% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA-estimation.R
\name{Lorenz.GA}
\alias{Lorenz.GA}
\title{Estimates the parameter vector in Lorenz regression using a genetic algorithm}
\usage{
Lorenz.GA(
  YX_mat,
  standardize = TRUE,
  popSize = 50,
  maxiter = 1500,
  run = 150,
  ties.method = c("random", "mean"),
  ties.Gini = c("random", "mean"),
  seed.random = NULL,
  weights = NULL,
  parallel = FALSE
)
}
\arguments{
\item{YX_mat}{A matrix with the first column corresponding to the response vector, the remaining ones being the explanatory variables.}

\item{standardize}{Should the variables be standardized before the estimation process? Default value is TRUE.}

\item{popSize}{Size of the population of candidates in the genetic algorithm. Default value is 50.}

\item{maxiter}{Maximum number ot iterations in the genetic algorithm. Default value is 1500.}

\item{run}{Number of iterations without improvement in the best fitness necessary for the algorithm to stop. Default value is 150.}

\item{ties.method}{What method should be used to break the ties in optimization program. Possible values are "random" (default value) or "mean". If "random" is selected, the ties are broken by further ranking in terms of a uniformly distributed random variable. If "mean" is selected, the average rank method is used.}

\item{ties.Gini}{what method should be used to break the ties in the computation of the Gini coefficient at the end of the algorithm. Possible values and default choice are the same as above.}

\item{seed.random}{seed.random imposed for the generation of the vector of uniform random variables used to break the ties. Default is NULL, in which case no seed.random is imposed.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{parallel}{Whether parallel computing should be used to distribute the computations in the genetic algorithm. Either a logical value determining whether parallel computing is used (TRUE) or not (FALSE, the default value). Or a numerical value determining the number of cores to use.}
}
\value{
A list with several components:
\describe{
   \item{\code{theta}}{the estimated vector of parameters.}
   \item{\code{LR2}}{the Lorenz-\eqn{R^2} of the regression.}
   \item{\code{Gi.expl}}{the estimated explained Gini coefficient.}
   \item{\code{niter}}{number of iterations attained by the genetic algorithm.}
   \item{\code{fit}}{value attained by the fitness function at the optimum.}
}
}
\description{
\code{Lorenz.GA} estimates the vector of parameters in Lorenz regression using the unit-norm normalization
It also returns the Lorenz-\eqn{R^2} of the regression as well as the estimated explained Gini coefficient.
}
\details{
The genetic algorithm is solved using function \code{\link[GA]{ga}} from the \emph{GA} package. The fitness function is coded in Rcpp to speed up computation time.
When discrete covariates are introduced and ties occur in the index, the default option randomly breaks them, as advised in Section 3 of Heuchenne and Jacquemain (2020)
}
\section{References}{

Heuchenne, C. and A. Jacquemain (2022). Inference for monotone single-index conditional means: A Lorenz regression approach. \emph{Computational Statistics & Data Analysis 167(C)}.
}

\examples{
data(Data.Incomes)
YX_mat <- cbind(Data.Incomes$Income, Data.Incomes$Age, Data.Incomes$Work.Hours)
Lorenz.GA(YX_mat, popSize = 40)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link[GA]{ga}}
}
