% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCorrAlpha.R
\name{makeCorrAlpha}
\alias{makeCorrAlpha}
\title{Construct a random correlation matrix of given dimensions from predefined Cronbach's Alpha}
\usage{
makeCorrAlpha(items, alpha, variance = 0.5)
}
\arguments{
\item{items}{(positive, int) number of rows & columns to generate}

\item{alpha}{(real) target Cronbach's Alpha
(usually positive, must be between -1 and +1)}

\item{variance}{(positive, real) Default = 0.5.
User-provided standard deviation of values sampled from a
normally-distributed log transformation.}
}
\value{
a correlation matrix
}
\description{
\code{makeCorrAlpha()} generates a random correlation
matrix of given dimensions and predefined Cronbach's Alpha
}
\note{
Random values generated by \code{makeCorrAlpha()} are highly volatile.
\code{makeCorrAlpha()} may not generate a feasible (positive-definite)
correlation matrix, especially when
\itemize{
\item variance is high relative to
\itemize{
\item desired Alpha, and
\item desired correlation dimensions
}
}

\code{makeCorrAlpha()} will inform the user if the resulting correlation
matrix is positive definite, or not.

If the returned correlation matrix is not positive-definite,
a feasible solution may still be possible. The user is encouraged to
try again, possibly several times, to find one.
}
\examples{

items <- 4
alpha <- 0.85
variance <- 0.5

set.seed(42)
cor_matrix <- makeCorrAlpha(items, alpha, variance)

print(cor_matrix)
alpha(cor_matrix)
eigenvalues(cor_matrix,1)

cor_matrix2 <- makeCorrAlpha(items = 6, alpha = 0.95)

print(cor_matrix2)
alpha(cor_matrix2)
eigenvalues(cor_matrix2,1)


}
