% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_bright_dark_period.R
\name{bright_dark_period}
\alias{bright_dark_period}
\title{Brightest or darkest continuous period}
\usage{
bright_dark_period(
  Light.vector,
  Time.vector,
  period = c("brightest", "darkest"),
  timespan = "10 hours",
  epoch = "dominant.epoch",
  loop = FALSE,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct},
\link[hms]{hms}, \link[lubridate]{duration}, or \link[base]{difftime}.}

\item{period}{String indicating the type of period to look for. Can be either
\code{"brightest"}(the default) or \code{"darkest"}.}

\item{timespan}{The timespan across which to calculate. Can be either a
\link[lubridate]{duration} or a \link[lubridate]{duration} string, e.g.,
\code{"1 day"} or \code{"10 sec"}.}

\item{epoch}{The epoch at which the data was sampled. Can be either a
\link[lubridate]{duration} or a string. If it is a string, it needs to be
either \code{"dominant.epoch"} (the default) for a guess based on the data, or a valid
\link[lubridate]{duration} string, e.g., \code{"1 day"} or \code{"10 sec"}.}

\item{loop}{Logical. Should the data be looped? If \code{TRUE}, a full copy of the data
will be concatenated at the end of the data. Makes only sense for 24 h data.
Defaults to \code{FALSE}.}

\item{na.rm}{Logical. Should missing values be removed for the calculation?
Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should the output be returned as a data frame? Defaults
to \code{TRUE}.}
}
\value{
A named list with the \code{mean}, \code{onset}, \code{midpoint}, and \code{offset} of the
calculated brightest or darkest period, or if \code{as.df == TRUE} a data frame
with columns named \verb{\{period\}_\{timespan\}_\{metric\}}. The output type corresponds
to the type of \code{Time.vector}, e.g., if \code{Time.vector} is HMS, the timing metrics
will be also HMS, and vice versa for POSIXct.
}
\description{
This function finds the brightest or darkest continuous period of a given
timespan and calculates its \code{mean} light level, as well as the timing of the period's
\code{onset}, \code{midpoint}, and \code{offset}. It is defined as the period with the maximum
or minimum mean light level. Note that the data need to be regularly spaced
(i.e., no gaps) for correct results.
}
\details{
Assumes regular 24h light data. Otherwise, results may not be
meaningful. Looping the data is recommended for finding the darkest period.
}
\examples{
# Dataset with light > 250lx between 06:00 and 18:00
dataset1 <-
  tibble::tibble(
    Id = rep("A", 24),
    Datetime = lubridate::as_datetime(0) + lubridate::hours(0:23),
    MEDI = c(rep(1, 6), rep(250, 13), rep(1, 5))
  )

dataset1 \%>\%
  dplyr::reframe(bright_dark_period(MEDI, Datetime, "brightest", "10 hours",
    as.df = TRUE))
dataset1 \%>\%
  dplyr::reframe(bright_dark_period(MEDI, Datetime, "darkest", "7 hours",
    loop = TRUE, as.df = TRUE))

# Dataset with duration as Time.vector
dataset2 <-
  tibble::tibble(
    Id = rep("A", 24),
    Datetime = lubridate::dhours(0:23),
    MEDI = c(rep(1, 6), rep(250, 13), rep(1, 5))
  )

dataset2 \%>\%
  dplyr::reframe(bright_dark_period(MEDI, Datetime, "brightest", "10 hours",
                                    as.df = TRUE))
dataset2 \%>\%
  dplyr::reframe(bright_dark_period(MEDI, Datetime, "darkest", "5 hours",
                                    loop = TRUE, as.df = TRUE))

}
\references{
Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
