% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_learn}
\alias{opf_learn}
\title{Executes the learning phase of the OPF classifier}
\usage{
opf_learn(trainFile, evaluatFile, precomputedDistance = NA)
}
\arguments{
\item{trainFile}{The training object produced by the opf_split (subGraph object)}

\item{evaluatFile}{The evaluation produced object by the opf_split (subGraph object)}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns a list which contains the classifier model object
}
\description{
Executes the learning phase of the OPF classifier
}
\details{
Executes the training phase
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.3,0.2,0.5,0)
T <- X$training
T2 <- X$testing
E <- X$evaluating
Y <- opf_learn(T,E)
class <- opf_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
